<form method="post" enctype="multipart/form-data" class="form-content-wrapper">
    <div class="page-header page-header-light">
        <div class="page-header-content header-elements-md-inline">
            <div class="page-title d-flex">
                <h4><i class="icon-arrow-left52 mr-2"></i> <span class="font-weight-semibold">{$title}</span> </h4>
                <a href="#" class="header-elements-toggle text-default d-md-none"><i class="icon-more"></i></a>
            </div>
            <div class="header-elements d-none">
                <div class="d-flex justify-content-center">
                    <button class="btn btn-sm btn-primary mr-2" type="submit" name="action" value="save"><i class="icon-floppy-disk mr-2"></i> {general:save}</button>
                    <button class="btn btn-sm btn-primary mr-2" type="submit" name="action" value="apply"><i class="icon-checkmark3 mr-2"></i> {general:apply}</button>&nbsp;
                    <a class="btn btn-sm btn-light" href="{$adminUrl}/payments">{general:cancel}</a>
                </div>
            </div>
        </div>

        <div class="breadcrumb-line breadcrumb-line-light header-elements-md-inline">
            <div class="d-flex">
                <div class="breadcrumb">
                    <a href="{$adminUrl}/overview" class="breadcrumb-item"><i class="icon-home2 mr-2"></i> Статистика</a>
                    <a href="{$adminUrl}/payments" class="breadcrumb-item">{$title}</a>
                    <span class="breadcrumb-item active">{general:add}</span>
                </div>

                <a href="#" class="header-elements-toggle text-default d-md-none"><i class="icon-more"></i></a>
            </div>

            <div class="header-elements d-none">
                <div class="breadcrumb justify-content-center"></div>
            </div>
        </div>
    </div>

    <div class="content">

        <div class="row">
            <div class="col-md-8">

                <div class="card">
                    <div class="card-header bg-transparent header-elements-inline">
                        <h6 class="card-title">{general:card:general}</h6>
                        <div class="header-elements"><div class="list-icons"><a class="list-icons-item" data-action="collapse"></a></div></div>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group form-group-float">
                                    <label class="form-group-float-label is-visible {if isset($errors.name)}text-danger{/if}">Название способа оплаты</label>
                                    <input type="text" class="form-control" id="title" autocomplete="off" name="payment[name]" value="{if isset($payment->name)}{$payment->name}{/if}" onblur="proposeFileName('name', 'fileName', 'payment', '{$config.filename_word_separator}', '{$config.convert_filename_to_lowercase}');" >
                                </div>
                            </div>
                            <div class="col-md-6">
	                            <label class="form-group-float-label is-visible {if isset($errors.fileNameExists)}text-danger{/if}">Выберите платежную систему</label>
	                            <select name="payment[fileName]" id="payment_module" class="form-control select">
		                            <option value="">Выберите платежную систему</option>
                                    {foreach from=$payment_modules item=payment_module key=key}{$payment->fileName} - {$key}
			                            <option value="{$key|escape}" {if isset($payment->fileName) && $payment->fileName == $key}selected{/if} >{$payment_module->name|escape}</option>
                                    {/foreach}
	                            </select>
{*                                <div class="form-group form-group-float">*}
{*                                    <label class="form-group-float-label is-visible {if isset($errors.fileName) || isset($errors.fileNameExists) || isset($errors.fileNameProhibited) || isset($errors.fileNameCharacters)}text-danger{/if}">{general:filename}</label>*}
{*                                    <input  type="text" class="form-control" id="fileName" autocomplete="off" name="payment[fileName]" value="{if isset($payment->fileName)}{$payment->fileName}{/if}" />*}
{*                                </div>*}
                            </div>
                        </div>
                    </div>
                </div>

                <div class="card">
                    <div class="card-header bg-transparent header-elements-inline">
                        <h6 class="card-title">{general:card:description}</h6>
                        <div class="header-elements">
                            <div class="list-icons">
                                <a class="list-icons-item" data-action="collapse"></a>
                            </div>
                        </div>
                    </div>
                    <div class="card-body flex-column flex-md-row m-0 p-0">
                        <div class="tab-content border-top-0 rounded-top-0 mb-0">
                            <div class="tab-pane fade show active" id="summary">
                                <textarea name="payment[summary]" class="description">{if isset($payment->summary)}{$payment->summary}{/if}</textarea>
                            </div>
                        </div>
                    </div>
                </div>


                <div class="col-md-12 main main_buttons text-center">
                    <button class="btn btn-sm btn-primary mr-2" type="submit" name="action" value="save"><i class="icon-floppy-disk mr-2"></i> {general:save}</button>
                    <button class="btn btn-sm btn-primary mr-2" type="submit" name="action" value="apply"><i class="icon-checkmark3 mr-2"></i> {general:apply}</button>	&nbsp;
                    <a class="btn btn-sm btn-light" href="{$adminUrl}/payments">{general:cancel}</a>
                </div>

            </div>


            <div class="col-md-4">
	            <div class="card">
                    <div class="card-header bg-transparent header-elements-inline">
                        <h6 class="card-title">{general:card:statusAndVisibility}</h6>
                        <div class="header-elements">
                            <div class="list-icons">
                                <a class="list-icons-item" data-action="collapse"></a>
                            </div>
                        </div>
                    </div>
                    <div class="card-body border-top-0">
                        <figure>
                            <div class="form-group form-group-float">
                                <label class="form-group-float-label is-visible">{general:status}</label>
                                {html_options options=$statuses name="payment[status]" id=status selected=$payment->status|default:'' class="form-control select"}
{*                                {if isset($payment->status)}*}
{*                                    {html_options options=$statuses name="payment[status]" id=status selected=$payment->status class="form-control select"}*}
{*                                {else}*}
{*                                    {html_options options=$statuses name="payment[status]" id=status class="form-control select"}*}
{*                                {/if}*}
                            </div>
                        </figure>
                        <figure>
                            {if isset($payment->addedOn)}
                                <div class="d-sm-flex flex-sm-wrap">
                                    <div class="font-weight-semibold">{general:created}</div>
                                    <div class="ml-sm-auto mt-2 mt-sm-0">{$payment->addedOn|date_format:"%d.%m.%Y %H:%M"} ({$payment->addedBy->loginName|default:"{general:unknowUser}"})</div>
                                </div>
                            {/if}
                            {if isset($payment->modifiedOn)}
                                <div class="d-sm-flex flex-sm-wrap">
                                    <div class="font-weight-semibold">{general:modified}</div>
                                    <div class="ml-sm-auto mt-2 mt-sm-0">{$payment->modifiedOn|date_format:"%d.%m.%Y %H:%M"} ({$payment->modifiedBy->loginName|default:"{general:unknowUser}"})</div>
                                </div>
                            {/if}
                        </figure>
                    </div>
                </div>

                <div class="card">
                    <div class="card-header bg-transparent header-elements-inline">
                        <h6 class="card-title">{general:card:providerPaymentSystem}</h6>
                        <div class="header-elements">
                            <div class="list-icons">
                                <a class="list-icons-item" data-action="collapse"></a>
                            </div>
                        </div>
                    </div>
                    <div class="card-body border-top-0">
                        {* Параметры модуля оплаты *}
{*                        {if isset($payment->fileName)}*}
                            {foreach from=$payment_modules item=payment_module key=key}
                            {if isset($payment->fileName) && $key|upper eq $payment->fileName|upper}
		                        <figure id="module_settings" module="{$key}" {if $key != $payment->fileName|escape} style="display:none;"{/if}>
		                            <div class="form-group form-group-float">
			                            <div class="form-group form-group-float">{image_file_name_exists filePath="/payment/$key/logo.png" style="width: 105px"}</div>

			                            {foreach from=$payment_module->settings item=setting}
				                            {if isset($setting->options) &&$setting->options|count > 1}
				                                <div class="form-group form-group-float">
					                                <label class="form-group-float-label is-visible">{$setting->name}</label>
					                                <select name="payment[settings][{$setting->variable}]" class="form-control select">
						                                {foreach from=$setting->options item=option}
							                                <option value="{$option->value}" {if !empty($payment->settings->{$setting->variable}) && $option->value eq $payment->settings->{$setting->variable|escape}}selected{/if}>{$option->name|escape}</option>
						                                {/foreach}
					                                </select>
				                                </div>
				                            {elseif isset($setting->options) && $setting->options|count eq 1}
					                            {$option = $setting->options|@first}
					                            <div class="form-group form-group-float">
						                            <label class="form-group-float-label is-visible" for="{$setting->variable}">{$setting->name|escape}</label>
						                            <input type="text" class="form-control" name="payment[settings][{$setting->variable}]" value="{if !empty($payment->settings->{$setting->variable})}{$payment->settings->{$setting->variable}}{/if}" id="{$setting->variable}" />
					                            </div>
				                            {else}
					                            <div class="form-group form-group-float">
						                            <label class="form-group-float-label is-visible" for="{$setting->variable}">{$setting->name|escape}</label>
						                            <input type="text" class="form-control" name="payment[settings][{$setting->variable}]" value="{if !empty($payment->settings)}{$payment->settings->{$setting->variable}}{/if}" id="{$setting->variable}" />
					                            </div>
				                            {/if}
			                            {/foreach}
			                            {* END Параметры модуля оплаты *}
		                            </div>
		                        </figure>
	                        {/if}
	                        {/foreach}
{*	                    {else}*}
{*                            {foreach from=$payment_modules item=payment_module key=key}*}
{*	                            <figure style="display:none;"id="module_settings" module='{$key}'>*}
{*		                            <div class="form-group form-group-float">*}
{*			                            <div class="form-group form-group-float">{image_file_name_exists filePath="/payment/$key/logo.png" style="width: 100px"}</div>*}

{*			                            {foreach from=$payment_module->settings item=setting}*}
{*				                            {if isset($setting->options) &&$setting->options|count > 1}*}
{*					                            <div class="form-group form-group-float">*}
{*						                            <label class="form-group-float-label is-visible">{$setting->name}</label>*}
{*						                            <select name="payment[settings][{$setting->variable}]" class="form-control select">*}
{*							                            {foreach from=$setting->options item=option}*}
{*								                            <option value="{$option->value}">{$option->name|escape}</option>*}
{*							                            {/foreach}*}
{*						                            </select>*}
{*					                            </div>*}
{*				                            {elseif isset($setting->options) && $setting->options|count eq 1}*}
{*					                            {$option = $setting->options|@first}*}
{*					                            <div class="form-group form-group-float">*}
{*						                            <label class="form-group-float-label is-visible" for="{$setting->variable}">{$setting->name|escape}</label>*}
{*						                            <input type="text" class="form-control" name="payment[settings][{$setting->variable}]" value="" id="{$setting->variable}" />*}
{*					                            </div>*}
{*				                            {else}*}
{*					                            <div class="form-group form-group-float">*}
{*						                            <label class="form-group-float-label is-visible" for="{$setting->variable}">{$setting->name|escape}</label>*}
{*						                            <input type="text" class="form-control" name="payment[settings][{$setting->variable}]" value="" id="{$setting->variable}" />*}
{*					                            </div>*}
{*				                            {/if}*}
{*			                            {/foreach}*}

{*		                            </div>*}
{*	                            </figure>*}

{*                            {/foreach}*}
{*                        {/if}*}
                        {* END Параметры модуля оплаты *}

                    </div>
                </div>

            </div>
        </div>
    </div>
</form>

{* Подключаем Tiny MCE *}
{include file='tinymce_init.tpl'}

<script>

    $(document).ready(function () {
        {if isset($errors.access_denied)} new Noty({ text: '{payments:errors:access_denied}', type: 'error', timeout: 3000 }).show(); {/if}
        {if isset($errors.name)} new Noty({ text: '{payments:errors:name}', type: 'error', timeout: 3000 }).show(); {/if}
        {if isset($errors.fileNameExists)} new Noty({ text: '{payments:errors:fileNameExists}', type: 'error', timeout: 3000 }).show(); {/if}
        {if isset($errors.not_saved)} new Noty({ text: '{payments:errors:not_saved}', type: 'error', timeout: 3000 }).show(); {/if}
        {if isset($errors.payment_not_found)} new Noty({ text: '{payments:errors:payment_not_found}', type: 'error', timeout: 3000 }).show(); {/if}

        {if isset($messages.saved)} new Noty({ text: '{payments:messages:payment_save}', type: 'success', timeout: 1500 }).show(); {/if}
    });

    $('select[name="payment[fileName]"]').change(function(){
        $('figure#module_settings').hide().find("input, select").attr("disabled", true);
        $('figure#module_settings[module=' + $(this).val() + ']').show().find("input, select").attr("disabled", false);
    });

</script>
