<form method="post" id="section" enctype="multipart/form-data">
    <div class="page-header page-header-light">
    	<div class="page-header-content header-elements-md-inline">
    		<div class="page-title d-flex">
    			<h4><i class="icon-arrow-left52 mr-2"></i> <span class="font-weight-semibold">{if isset($title)}{$title}{/if}</span></h4>
    			<a href="#" class="header-elements-toggle text-default d-md-none"><i class="icon-more"></i></a>
    		</div>
    
    		<div class="header-elements d-none">
    			<div class="d-flex justify-content-center">
                    <button class="btn btn-sm btn-primary mr-2" type="submit" name="action" value="save"><i class="icon-floppy-disk mr-2"></i> {general:save}</button>
                    <button class="btn btn-sm btn-primary mr-2" type="submit" name="action" value="apply"><i class="icon-checkmark3 mr-2"></i> {general:apply}</button>
                    <a class="btn btn-sm btn-light" href="{$adminUrl}/sections{if isset($page)}?page={$page}{/if}{if isset($parentId)}&parentId={$parentId}{/if}">{general:cancel}</a>
    			</div>
    		</div>
    	</div>
    
    	<div class="breadcrumb-line breadcrumb-line-light header-elements-md-inline">
    		<div class="d-flex">
    			<div class="breadcrumb">
    				<a href="{$adminUrl}/overview" class="breadcrumb-item"><i class="icon-home2 mr-2"></i> Статистика</a>
                    <a href="{$adminUrl}/sections" class="breadcrumb-item">{if isset($title)}{$title}{/if}</a>
    				<span class="breadcrumb-item active">{general:add}</span>
    			</div>
    
    			<a href="#" class="header-elements-toggle text-default d-md-none"><i class="icon-more"></i></a>
    		</div>
    
    		<div class="header-elements d-none">
    			<div class="breadcrumb justify-content-center">
    			</div>
    		</div>
    	</div>
    </div>
    <!-- /page header -->

    <div class="content">
        <div class="row"> 
            <div class="col-md-8">
    		    <div class="card">
        		    <div class="card-header bg-transparent header-elements-inline">
        				<h6 class="card-title">{general:card:general}</h6>
        				<div class="header-elements">
    						<div class="list-icons">
    	                		<a class="list-icons-item" data-action="collapse"></a>
                    		</div>
                		</div>
        			</div>
                    <div class="card-body">
        			
        			    <div class="row">
            			   
            			    <div class="col-md-6">
                                <div class="form-group form-group-float">
                                    <label class="form-group-float-label is-visible {if isset($errors.error_parent_type) || isset($errors.sectionType)}text-danger{/if}">{sections:sectionType}</label>
                                    {html_options options=$types selected=$section.type|default:'' name="section[type]" class="form-control select" id="type"}
                                </div>
                              
            			    </div>
            			    
                            <div class="col-md-6">
                                <div class="form-group form-group-float">
                                    <label class="form-group-float-label is-visible {if isset($errors.error_parent_typeContent) || isset($errors.error_typeContent)}text-danger{/if}">{sections:contentType}</label>
                                    {html_options options=$typeContents selected=$section.typeContent|default:0 name="section[typeContent]" class="form-control select" id="typeContent"}
                                </div>
            			    </div>
                            <div class="col-md-12">
                                <div class="form-group form-group-float pages">
                                    <label class="form-group-float-label is-visible">{sections:general:parent}</label>
                                    {if isset($parents)}
                                        {if isset($section.parentId)}
                                            {html_options options=$parents name="section[parentId]" selected=$section.parentId id="parentId" class="form-control select"}
                                        {else}
                                            {html_options options=$parents name="section[parentId]" selected=$parentId|default:0 id="parentId" class="form-control select"}
                                        {/if}
                                    {else}
                                        <label class="field_name">{sections:general:na}</label>
                                        <input type="hidden" name="section[parentId]" value="0"/>
                                    {/if}
                                </div> 
                            </div>
                            <div class="col-md-6">
                                <div class="form-group form-group-float">
                                    <label class="form-group-float-label is-visible {if isset($errors.name)}text-danger{/if}">{sections:general:name}</label>
                                    <input type="text" class="form-control" autocomplete="off" id="name" name="section[name]" value="{if isset($section.name)}{$section.name}{/if}" />
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group form-group-float">
                                    <label class="form-group-float-label is-visible">{sections:general:alias}</label>
                                    <input type="text" class="form-control" autocomplete="off" id="alias" name="section[alias]" value="{if isset($section.alias)}{$section.alias nofilter}{/if}"/>
                                </div>
                            </div>

                            <div class="col-md-12">
                                <div class="form-group form-group-float">
                                    <label class="form-group-float-label is-visible {if isset($errors.fileName) || isset($errors.fileNameExists) || isset($errors.fileNameProhibited) || isset($errors.fileNameCharacters)}text-danger{/if}">{sections:general:filename}</label>
                                    <input type="text" class="form-control" id="fileName" name="section[fileName]" value="{if isset($section.fileName)}{$section.fileName|escape}{/if}" />
                                </div>
                            </div>
{*				            <div class="col-md-6">*}
{*					            <div class="form-group form-group-float">*}
{*						            <label class="form-group-float-label is-visible">Показать в этом разделе и другие разделы</label>*}

{*						            {html_options options=$parents selected=$section.sectionIds id="parentId" name="section[sectionIds]" class="form-control select" multiple="multiple"}*}

{*					            </div>*}
{*				            </div>*}


{*				            <div class="col-md-12">*}
{*					            <div class="form-group form-group-float">*}
{*						            <label class="form-group-float-label is-visible">путь к видео</label>*}
{*						            <input type="text" class="form-control" id="videoUrl" name="section[videoUrl]" value="{if isset($section.videoUrl)}{$section.videoUrl}{/if}"/>*}
{*					            </div>*}
{*				            </div>*}

                        </div> 
                    </div>
    		    </div>

                <div class="card collapse {if isset($section.enableGallery) and $section.enableGallery eq 1}show{/if}" id="gallery-card">
        		    <div class="card-header bg-transparent header-elements-inline">
        				<h6 class="card-title">{general:card:imageLibrary}</h6>
        				<div class="header-elements">
    						<div class="list-icons">
    	                		<a class="list-icons-item" data-action="collapse"></a>
                    		</div>
                		</div>
        			</div>
                    <div class="card-body">
        			    <div class="row gallery gallery-product gallery-sortable mt-2" id="fileList">
                            {if isset($section.gallery)}
                                {foreach item=file from=$section.gallery}
                                    <figure class="gallery-item gallery-item-images mb-0" id="gallery-item-{$file->imageId}" data-id="{$file->imageId}">
                                        <div class="move_zone image">
                                            <img src="{$file->medium}" alt="{if isset($file->title)}{$file->title}{/if}"/>
                                            <ul class="gallery-item-controls">
                                                <li><span>{$file->orderBy}</span></li>
                                                <li>
                                                    <span class="edit_image"
                                                          id="edit_image_{$file->imageId}"
                                                          data-id="{$file->imageId}"
                                                          data-title="{$file->title}"
                                                          data-alias="{$file->alias}"
                                                          data-description="{$file->description}"
                                                          data-link="{$file->link}"
                                                          data-position="{$file->position}"
                                                          data-module="section"
                                                          data-action="editPictureInfo"
                                                          data-confirm="Добавить описание к картинке"
                                                    ><i class="icon-quill4"></i></span></li>
                                                <li>
                                                    <span onclick="deletePicture({$file->imageId}, 'section');"><i class="icon-cross2"></i></span>
                                                </li>
                                            </ul>
                                        </div>
                                        <div class="meta" id="meta_image_{$file->imageId}" style="padding: 0;">
                                            <span id="im_title" class="font-weight-semibold">{$file->title}</span>
                                            <span id="im_alias" class="font-weight-semibold">{$file->alias}</span>
                                            <span id="im_description">{$file->description nofilter}</span>
                                            <span id="im_link">{$file->link}</span>
                                            <span id="im_position" class="badge badge-primary" style="color: #fff;">{$file->position}</span>
                                        </div>
                                    </figure>
                                {/foreach}
                            {/if}
                        </div>

                    </div>
                    <div class="card-footer bg-white d-sm-flex justify-content-sm-between align-items-sm-center">
                        <a class="btn btn-sm btn-primary btn-upload read-more" href="javascript:void('')"
                           data-type="gallery"
                           data-path="/"
                           data-action="read_more"
                           data-module="files"
                        ><i class="icon-images2 mr-2"></i> {general:uploadFiles} </a>
                        <a class="btn btn-sm btn-primary btn-sorting collapse" href="javascript:void('')"
                           data-action="sortPictures"
                           data-module="section"
                        ><i class="icon-checkmark3 mr-2"></i> {general:apply}</a>
                    </div>

                </div>

	            <div class="card">
                    <div class="card-header bg-transparent header-elements-inline">
    				    <h6 class="card-title">{general:card:description}</h6>
                        <div class="header-elements">
    						<div class="list-icons">
    	                		<a class="list-icons-item" data-action="collapse"></a>
                    		</div>
                		</div>
    			    </div>
                    <div class="card-body flex-column flex-md-row m-0 p-0">
	                     <textarea name="section[content]" class="description">{if isset($section.content)}{$section.content}{/if}</textarea>
    			    </div>
    		    </div>

                <div class="col-md-12 main main_buttons text-center">
                    <button class="btn btn-sm btn-primary mr-2" type="submit" name="action" value="save"><i class="icon-floppy-disk mr-2"></i> {general:save}</button>
                    <button class="btn btn-sm btn-primary mr-2" type="submit" name="action" value="apply"><i class="icon-checkmark3 mr-2"></i> {general:apply}</button>
                    <a class="btn btn-sm btn-light" href="{$adminUrl}/sections{if isset($page)}?page={$page}{/if}{if !empty($parentId)}&parentId={$parentId}{/if}">{general:cancel}</a>
                </div>
            </div>
    
    
            <div class="col-md-4">
                {* STATUS *}
        		<div class="card">
    							
                    <div class="card-header bg-transparent header-elements-inline">
                        <h6 class="card-title">{general:card:statusAndVisibility}</h6>
    					<div class="header-elements">
    						<div class="list-icons">
    	                		<a class="list-icons-item" data-action="collapse"></a>
                    		</div>
                		</div>
    				</div>
    				<div class="card-body border-top-0">
					    <figure>
						    <div class="form-group form-group-float">
							    <label class="form-group-float-label is-visible">{general:status}</label>
                                {html_options options=$statuses selected=$section.status|default:'' name="section[status]" class="form-control select" id="status"}
						    </div>
					    </figure>
					    <figure>
						    <div class="form-group form-group-float">
							    <label class="form-group-float-label is-visible">Тип ссылки <br /><i><code class="p-0">если нужно чтоб переходило на <b>стороний сайт</b> или перейти на какую то <b>другую страницу</b>, укажите (Внешняя ссылка) и <b>обязательно прописать ссылку</b></code></i></label>
                                {html_options options=$urlTypes selected=$section.urlType|default:'' name="section[urlType]" class="form-control select selectUrlType" id="selectUrlType"}
						    </div>
						    <div class="form-group form-group-float collapse {if !empty($section.urlType) AND $section.urlType eq 'external'}show{/if}" id="icon-urlType">
							    <label class="form-group-float-label is-visible  {if isset($errors.externalLink)}text-danger{/if}">Ссылка <code>(t.me/@life)</code></label>
							    <input type="text" class="form-control" id="link" name="section[externalLink]" value="{if isset($section.externalLink)}{$section.externalLink}{/if}"/>
						    </div>
					    </figure>

                        <figure>
	                        <div class="form-check">
		                        <label class="form-check-label">
			                        <input type="checkbox" class="form-check-input-styled" name="section[showMainPage]" value="1" {if isset($section.showMainPage) and $section.showMainPage eq 1}checked{/if} data-fouc="">
			                        Показать как блок на главной странице
		                        </label>
	                        </div>
                            <div class="form-check">
                                <label class="form-check-label">
                                    <input type="checkbox" class="form-check-input-styled" name="section[topMenu]" value="1" {if isset($section.topMenu) and $section.topMenu eq 1}checked{/if} data-fouc="">
                                    {sections:mainMenu}
                                </label>
                            </div>

                            <div class="form-check">
                                <label class="form-check-label">
                                    <input type="checkbox" class="form-check-input-styled" name="section[footerMenu]" value="1" {if isset($section.footerMenu) and $section.footerMenu eq 1}checked{/if} data-fouc="">
                                    {sections:footerMenu}
                                </label>
                            </div>


                            <div class="form-check">
                                <label class="form-check-label">
                                    <input type="checkbox" class="form-check-input-styled" name="section[enableGallery]" data-fouc="" value="1"
                                           {if isset($section.enableGallery) and $section.enableGallery eq 1}checked{/if}
                                           data-toggle="collapse"
                                           data-target="#gallery-card"
                                           aria-expanded="{if isset($section.enableGallery) and $section.enableGallery eq 1}true{else}false{/if}"
                                    >
                                    {sections:photoGallery}
                                </label>
                            </div>

                            <div class="form-check">
                                <label class="form-check-label">
                                    <input type="checkbox" id="enableIcon" class="form-check-input-styled" name="section[enableIcon]" data-fouc="" value="1"
                                           {if isset($section.enableIcon) and $section.enableIcon eq 1}checked{/if}
                                           data-toggle="collapse"
                                           data-target="#icon-enable"
                                           aria-expanded="{if isset($section.enableIcon) and $section.enableIcon eq 1}true{else}false{/if}"
                                    >
                                    {sections:iconSection}
                                </label>
                            </div>
                            <div class="form-group form-group-float collapse {if isset($section.enableIcon) and $section.enableIcon eq 1}show{/if}" id="icon-enable">
                                <label class="form-group-float-label is-visible">{sections:icon}</label>
                                <input type="text" class="form-control" autocomplete="off" id="icon" name="section[icon]" value="{if isset($section.icon)}{$section.icon}{/if}"/>
                            </div>

{*	                        <div class="form-check">*}
{*		                        <label class="form-check-label">*}
{*			                        <input type="checkbox" class="form-check-input-styled" name="section[enableVideo]" value="1" {if isset($section.enableVideo) and $section.enableVideo eq 1}checked{/if} data-fouc="">*}
{*			                        Видео для этого раздела*}
{*		                        </label>*}
{*	                        </div>*}
{*	                        <div class="form-check">*}
{*		                        <label class="form-check-label">*}
{*			                        <i><code class="p-0">Если нужно отобразить видео в этом разделе, загрузите видео с названием файла как этот раздел имеет название <b>URL</b>.*}
{*					                        Загрузить видео можно через вкладку "Описание->Анонс или Описание->Подробнее, нажав на кнопку </code><span class="icon-folder-open2"></span><code>,*}
{*					                        в "Файл менеджер -> Создать плей-лист видео", после поставить галочку ниже </code></i>*}
{*		                        </label>*}
{*	                        </div>*}

                        </figure>

                        <figure>
                            {if isset($section.modifiedOn)}
                                <div class="d-sm-flex flex-sm-wrap">
                                    <div class="font-weight-semibold">{general:modified}</div>
                                    <div class="ml-sm-auto mt-2 mt-sm-0"> {$section.modifiedOn nofilter} ({$section.modifiedBy.loginName|default:"unknown user"})</div>
                                </div>
                            {/if}
                            {if isset($section.addedOn)}
                                <div class="d-sm-flex flex-sm-wrap">
                                    <div class="font-weight-semibold">{general:created}</div>
                                    <div class="ml-sm-auto mt-2 mt-sm-0">{$section.addedOn nofilter} ({$section.addedBy.loginName|default:"unknown user"})</div>
                                </div>
                            {/if}
                        </figure>
    				</div>
    			</div>
    			{* IMAGE *}
                <div class="card">
    				<div class="card-header bg-transparent header-elements-inline">
        				<h6 class="card-title">{general:card:addImage}</h6>
    					<div class="header-elements">
    						<div class="list-icons">
    	                		<a class="list-icons-item" data-action="collapse"></a>
                    		</div>
                		</div>
    				</div>

    				<div class="card-body">
                        <div class="content-image gallery">
                            {if isset($section.image)}
                                <div class="gallery-item item-{$section.image->imageId}" id="image_general">
                                    <div class="image" id="image-{$section.image->imageId}">
                                        <img src="{$section.image->medium}" />
                                        <ul class="gallery-item-controls">
                                            <li><span onclick="deleteImage({$section.image->imageId}, 'section');"><i class="icon-cross2"></i></span></li>
                                        </ul>
                                    </div>

                                </div>
                            {/if}
                        </div>
    				</div>
                    <div class="card-footer bg-white d-sm-flex justify-content-sm-between align-items-sm-center">
                        <a class="btn btn-sm btn-primary btn-upload read-more" href="javascript:void('')"
                           data-type="image"
                           data-path="/"
                           data-action="read_more"
                           data-module="files"
                        ><i class="icon-image2 mr-2"></i> {general:uploadFile} </a>
                    </div>
    			</div>

	                {* FILE *}
		            <div class="card">
			            <div class="card-header bg-transparent header-elements-inline">
				            <h6 class="card-title">Брошюра (pdf, word)</h6>
				            <div class="header-elements"><div class="list-icons"><a class="list-icons-item" data-action="collapse"></a></div></div>
			            </div>

			            <div class="card-body">
				            <div class="form-group" id="pdf_docs">
					            {if isset($section.docs)}
						            {foreach item=file from=$section.docs}
							            <figure class="docs mb-0" id="docs-item-{$file->imageId}">
								            <div class="input-group">
	                                            {if $file->fileFormat eq 'pdf'}
									            <embed src="/uploads/docs/{$file->fileName}" width="100%" height="100%" class="mb-2" type="application/pdf"/>
									            {/if}
									            <span class="input-group-prepend"><img src="/admin/assets/ico/{$file->fileFormat}.svg"/></span>
									            <input type="text" class="form-control" value="{$file->fileName}" placeholder="" readonly>
									            <span class="input-group-append remove-docs" style="margin-top: 15px;margin-left: -1px;" onclick="deleteDocs({$file->imageId}, 'section');"><i class="icon-cross2"></i></span>
								            </div>
							            </figure>
						            {/foreach}
					            {/if}
				            </div>
			            </div>
			            <div class="card-footer bg-white d-sm-flex justify-content-sm-between align-items-sm-center">
				            <a class="btn btn-sm btn-primary btn-upload btn-docs read-more" href="javascript:void('')"
				               data-type="docs"
				               data-path="docs"
				               data-action="read_more"
				               data-module="files"
				            ><i class="icon-image2 mr-2"></i> {general:uploadFile} </a>
			            </div>
		            </div>

    			{* SEO card-collapsed *}
    			<div class="card">
    			    <div class="card-header bg-transparent header-elements-inline">
    				    <h6 class="card-title">{general:card:seo}</h6>
                        <div class="header-elements">
	                        <ul class="list-inline mb-0">
		                        <li class="list-inline-item"><button type="button" class="btn btn-outline-primary border-transparent" onclick="auto_keywords();">Сгенерировать ключевые слова</button></li>
		                        <li class="list-inline-item"><a class="list-icons-item" data-action="collapse"></a></li>
	                        </ul>

                		</div>
    			    </div>
    
        			<div class="card-body flex-column flex-md-row m-0">
            			<div class="form-group form-group-float">
                            <label class="form-group-float-label is-visible">{general:metaTitle}</label>
                            <input class="form-control" autocomplete="off" id="meta_title" type="text" name="section[meta_title]" value="{if isset($section.meta_title)}{$section.meta_title}{/if}"/>
                        </div>

				        <div class="form-group">
					        <label class="form-group-float-label is-visible">{general:keywords}</label>
					        <div class="input-group">
						        <input type="text" class="form-control tokenfield-primary" id="keywords" name="section[keywords]" value="{if isset($section.keywords)}{$section.keywords}{/if}" data-fouc>
					        </div>
				        </div>

                        <div class="form-group form-group-float">
                            <label class="form-group-float-label is-visible">{general:description}</label>
                            <textarea name="section[description]" id="description" class="form-control" rows="4">{if isset($section.description)}{$section.description}{/if}</textarea>
                        </div>
        			</div>
        		</div>

                {* SETTINGS *}
                <div class="card card-collapsed">
                    <div class="card-header bg-transparent header-elements-inline">
                        <h6 class="card-title">{general:card:advanced}</h6>
                        <div class="header-elements">
                            <div class="list-icons">
                                <a class="list-icons-item" data-action="collapse"></a>
                            </div>
                        </div>
                    </div>

                    <div class="card-body">
                        <fieldset class="mb-3">
                            <legend class="text-uppercase font-size-sm font-weight-bold">Применение для данного {general:section}</legend>

                            <div class="form-group form-group-float">
                                <label class="form-group-float-label is-visible">{general:template}</label>
                                {html_options values=$templates output=$templates selected=$section.templateName|default:'' name="section[templateName]" class="form-control select"}
                            </div>
                            <div class="form-group form-group-float">
                                <label class="form-group-float-label is-visible">{general:caching}</label>

                                <select name="section[isCached]" class="form-control select">
                                    <option value="0" {if isset($section.isCached) and $section.isCached == 0}selected{/if}>{general:cachingDefault}</option>
                                    <option value="-1" {if isset($section.isCached) and $section.isCached == -1}selected{/if}>{general:cachingDisabled}</option>
                                    <option value="1" {if isset($section.isCached) and $section.isCached == 1}selected{/if}>{general:enableCachingFor}</option>
                                </select>

	                            <div class="form-group form-group-float">
	                                <div class="input-group">
		                                <span class="input-group-prepend"><span class="input-group-text"><i class="icon-watch2"></i></span></span>
		                                <div class="wmin-sm-200 mr-3">
			                                {html_options options=$cachingTimeOptions  name="section[cacheTime]" selected=$section.cacheTime|default:1 class="form-control select"}
		                                </div>
		                                <div class="wmin-sm-200">
			                                {html_options options=$cachingPeriodOptions name="section[cachePeriod]" selected=$section.cachePeriod|default:86400 class="form-control select"}
		                                </div>
	                                </div>
                                </div>
                            </div>
                            <div class="form-group form-group-float">
                                <label class="form-group-float-label is-visible">{general:comments}</label>
                                <select name="section[commentsEnabled]" class="form-control select">
                                    <option value="0" {if isset($section.commentsEnabled) and $section.commentsEnabled == 0}selected{/if}>{general:defaultComments}</option>
                                    <option value="-1" {if isset($section.commentsEnabled) and $section.commentsEnabled == -1}selected{/if}>{general:disableComments}</option>
                                    <option value="1" {if isset($section.commentsEnabled) and $section.commentsEnabled == 1}selected{/if}>{general:enableComments}</option>
                                </select>
                            </div>
                        </fieldset>

                        <fieldset class="mb-3">
                            <legend class="text-uppercase font-size-sm font-weight-bold">Применение для подразделов данного раздела</legend>
                            <div class="form-group form-group-float">
                                <label class="form-group-float-label is-visible">{general:template}</label>
                                {html_options values=$templates output=$templates selected=$section.subTemplateName|default:'' name="section[subTemplateName]" class="form-control select"}
                            </div>
                            <div class="form-group form-group-float">
                                <label class="form-group-float-label is-visible">{general:caching}</label>
                                <select name="section[subIsCached]" class="form-control select">
                                    <option value="0" {if isset($section.subIsCached) and $section.subIsCached == 0}selected{/if}>{general:cachingDefault}</option>
                                    <option value="-1" {if isset($section.subIsCached) and $section.subIsCached == -1}selected{/if}>{general:cachingDisabled}</option>
                                    <option value="1" {if isset($section.subIsCached) and $section.subIsCached == 1}selected{/if}>{general:enableCachingFor}</option>
                                </select>
	                            <div class="form-group form-group-float">
	                                <div class="input-group">
		                                <span class="input-group-prepend"><span class="input-group-text"><i class="icon-watch2"></i></span></span>
		                                <div class="wmin-sm-200 mr-3">
			                                {html_options options=$cachingTimeOptions name="section[subCacheTime]" selected=$section.subCacheTime|default:1 class="form-control select"}
		                                </div>
		                                <div class="wmin-sm-200">
			                                {html_options options=$cachingPeriodOptions name="section[subCachePeriod]" selected=$section.subCachePeriod|default:86400 class="form-control select"}
		                                </div>
	                                </div>
                                </div>
                            </div>
                            <div class="form-group form-group-float">
                                <label class="form-group-float-label is-visible">{general:comments}</label>
                                <select name="section[subCommentsEnabled]" class="form-control select">
                                    <option value="0" {if isset($section.subCommentsEnabled) and $section.subCommentsEnabled == 0}selected{/if}>{general:defaultComments}</option>
                                    <option value="-1" {if isset($section.subCommentsEnabled) and $section.subCommentsEnabled == -1}selected{/if}>{general:disableComments}</option>
                                    <option value="1" {if isset($section.subCommentsEnabled) and $section.subCommentsEnabled == 1}selected{/if}>{general:enableComments}</option>
                                </select>
                            </div>
                        </fieldset>

                        <fieldset class="mb-3">
                            <legend class="text-uppercase font-size-sm font-weight-bold">Применение для контента данного раздела</legend>
                            <div class="form-group form-group-float">
                                <label class="form-group-float-label is-visible">{general:template}</label>
                                {html_options values=$templates output=$templates selected=$section.artTemplateName|default:'' name="section[artTemplateName]" class="form-control select"}
                            </div>
                            <div class="form-group form-group-float">
                                <label class="form-group-float-label is-visible">{general:caching}</label>
                                <select name="section[artIsCached]" class="form-control select">
                                    <option value="0" {if isset($section.artIsCached) and $section.artIsCached == 0}selected{/if}>{general:cachingDefault}</option>
                                    <option value="-1" {if isset($section.artIsCached) and $section.artIsCached == -1}selected{/if}>{general:cachingDisabled}</option>
                                    <option value="1" {if isset($section.artIsCached) and $section.artIsCached == 1}selected{/if}>{general:enableCachingFor}</option>
                                </select>

	                            <div class="form-group form-group-float">
	                                <div class="input-group">
		                                <span class="input-group-prepend"><span class="input-group-text"><i class="icon-watch2"></i></span></span>
		                                <div class="wmin-sm-200 mr-3">
			                                {html_options options=$cachingTimeOptions name="section[artCacheTime]" selected=$section.artCacheTime|default:1 class="form-control select"}
		                                </div>
		                                <div class="wmin-sm-200">
			                                {html_options options=$cachingPeriodOptions name="section[artCachePeriod]" selected=$section.artCachePeriod|default:86400 class="form-control select"}
		                                </div>
                                    </div>
                                </div>
                            </div>
                        </fieldset>

                    </div>
                </div>

            </div>
        </div>
    </div>
</form>

{* Подключаем Tiny MCE *}
{include file='tinymce_init.tpl'}

{* Подключаем filemanager *}
{include file='uploads_init.tpl'}

<script>
    $(document).ready(function () {

        {if isset($messages.saved)} new Noty({ text: '{sections:messages:0}', type: 'success' }).show(); {/if}
        {if isset($messages.deleted)} new Noty({ text: '{sections:messages:1}', type: 'success' }).show(); {/if}
        {if isset($messages.sorted)} new Noty({ text: '{sections:messages:2}', type: 'success' }).show();{/if}

        {if isset($errors.not_saved)} new Noty({ text: '{sections:errors:0}', type: 'error' }).show(); {/if}
        {if isset($errors.section_not_found)} new Noty({ text: '{sections:errors:1}', type: 'error' }).show();{/if}
        {if isset($errors.name)} new Noty({ text: '{sections:errors:2}', type: 'error' }).show(); {/if}
        {if isset($errors.fileName)} new Noty({ text: '{sections:errors:3}', type: 'error' }).show(); {/if}
        {if isset($errors.fileNameExists)} new Noty({ text: '{sections:errors:4}', type: 'error' }).show(); {/if}
        {if isset($errors.htaccess)} new Noty({ text: '{sections:errors:5}', type: 'error' }).show(); {/if}
        {if isset($errors.serializations)} new Noty({ text: '{sections:errors:6}', type: 'error' }).show(); {/if}
        {if isset($errors.fileNameProhibited)} new Noty({ text: '{sections:errors:7}', type: 'error' }).show(); {/if}
        {if isset($errors.fileNameCharacters)} new Noty({ text: '{sections:errors:8}', type: 'error' }).show(); {/if}
        {if isset($errors.error_typeContent)} new Noty({ text: '{sections:errors:13}', type: 'error' }).show(); {/if}
        {if isset($errors.error_parent_typeContent)} new Noty({ text: '{sections:errors:15}', type: 'error' }).show(); {/if}
        {if isset($errors.error_parent_type)} new Noty({ text: '{sections:errors:16}', type: 'error' }).show(); {/if}
        {if isset($errors.sectionType)} new Noty({ text: '{sections:errors:13}', type: 'error' }).show(); {/if}
        {if isset($errors.externalLink)} new Noty({ text: 'Укажите ссылку на модальное окно или внешнюю ссылку', type: 'error' }).show(); {/if}

    });

    $(function () { function e() { alias_touched || $("#alias").val(a()), meta_title_touched || $("#meta_title").val(m()), keywords_touched || $("#keywords").val(i()), description_touched || $("#description").val(t()), fileName_touched || $("#fileName").val(n()) } function a() { return name = $("#name").val() } function m() { return name = $("#name").val() } function i() { return name = $("#name").val() } function t() { return name = $("#name").val() } function n() { return fileName = $("#name").val(), fileName = fileName.replace(/[\s]+/gi, "{$config.filename_word_separator}"), fileName = l(fileName), fileName = fileName.replace(/[^0-9a-z_\-]+/gi, "").toLowerCase() } function l(e) { for (var a = "А-а-Б-б-В-в-Ґ-ґ-Г-г-Д-д-Е-е-Ё-ё-Є-є-Ж-ж-З-з-И-и-І-і-Ї-ї-Й-й-К-к-Л-л-М-м-Н-н-О-о-П-п-Р-р-С-с-Т-т-У-у-Ф-ф-Х-х-Ц-ц-Ч-ч-Ш-ш-Щ-щ-Ъ-ъ-Ы-ы-Ь-ь-Э-э-Ю-ю-Я-я".split("-"), i = "A-a-B-b-V-v-G-g-G-g-D-d-E-e-E-e-E-e-ZH-zh-Z-z-I-i-I-i-I-i-J-j-K-k-L-l-M-m-N-n-O-o-P-p-R-r-S-s-T-t-U-u-F-f-H-h-TS-ts-CH-ch-SH-sh-SCH-sch-'-'-Y-y-'-'-E-e-YU-yu-YA-ya".split("-"), t = "", n = 0, l = e.length; l > n; n++) {
        var o = e.charAt(n),c = a.indexOf(o);t += c >= 0 ? i[c] : o
    } return t }
        alias_touched = !0,
            meta_title_touched = !0,
            keywords_touched = !0,
            description_touched = !0,
            fileName_touched = !0,
        ($("#alias").val() == a() || "" == $("#alias").val()) && (alias_touched = !1),
        ($("#meta_title").val() == i() || "" == $("#meta_title").val()) && (meta_title_touched = !1),
        ($("#keywords").val() == i() || "" == $("#keywords").val()) && (keywords_touched = !1),
        ($("#description").val() == t() || "" == $("#description").val()) && (description_touched = !1),
        ($("#fileName").val() == n() || "" == $("#fileName").val()) && (fileName_touched = !1),
            $("#alias").change( function () { alias_touched = !0 }),
            $("#meta_title").change( function () { meta_title_touched = !0 }),
            $("#keywords").change( function () { keywords_touched = !0 }),
            $("#description").change( function () { description_touched = !0 }),
            $("#fileName").change( function () { fileName_touched = !0 }),
            $("#name").keyup( function () { e() })
    });


    $(document).ready(function(){
        var type = $('#type :selected').val();
        if (type === 'plain') {
            $('#typeContent').prop("disabled", true);
            $('.pages').hide();
        }

        $('#type').change(function() {
            var typeContent = $(this).val();
            $('#typeContent').prop("disabled", true);
            $('.pages').hide();
            if (typeContent === 'tree') {
                $('.pages').show();
                $('#typeContent').prop("disabled", false);
            }
        });


        // добавление информации к картинке в галереи
        $(document).on('click', '.edit_image', function() {
            var $this =  $(this);
            var confirm = $this.attr('data-confirm'),
	            imageId = $this.attr('data-id'),
	            title = $this.attr('data-title'),
                alias = $this.attr('data-alias'),
	            description =$this.attr('data-description'),
	            link = $this.attr('data-link'),
	            position = $this.attr('data-position');

            bootbox.prompt({
                title: confirm,
                message:'<div class="form-group">' +
	                        '<label class="form-group-float-label is-visible">Заголовок</label>'+
                            '<input type="text" class="form-control" id="image_title" value="'+title+'" />' +
	                    '</div>' +
                        '<div class="form-group">' +
                            '<label class="form-group-float-label is-visible">Альтернативный заголовок</label>'+
                            '<input type="text" class="form-control" id="image_alias" value="'+alias+'" />' +
                        '</div>' +
                        '<div class="form-group">' +
	                        '<label class="form-group-float-label is-visible">Описание</label>' +
	                        '<textarea rows="3" cols="3" class="form-control" placeholder="" id="image_description">'+description+'</textarea>'+

	                    '</div>' +
                        '<div class="form-group">' +
	                        '<label class="form-group-float-label is-visible">Ссылка</label>'+
                            '<input type="text" class="form-control" id="image_link" value="'+link+'" />' +
	                    '</div>',
                inputType: 'select',
                value: position,
                inputOptions: [
                    { text: 'По умолчанию', value: 'default' },
                    { text: 'Банер', value: 'banner' },
                    { text: 'Блок', value: 'block' },
                    { text: 'Карусель', value: 'carousel' },
                    { text: 'Модальное окно', value: 'modal' },
                    { text: 'Баннер для PDF', value: 'pdf' }
                ],
                buttons: {
                    cancel: { label: '{general:cancel}', className: 'btn-sm btn-light' },
                    confirm: { label: "{general:yes}", className: 'btn-sm  btn-primary' }
                },
                callback: function (result) {
                    console.log(result);

                    var link = $("#image_link").val(), title = $("#image_title").val(), alias = $("#image_alias").val(), description = $("#image_description").val();


                    if (result !== null) {
                        $.post('{$adminUrl}/section?action=editPictureInfo', { imageId: imageId, 'picture[title]': title, 'picture[alias]' : alias, 'picture[description]': description, 'picture[link]': link, 'picture[position]' : result }, function (response) {
                            if (response.status === 200) {
                                console.log(imageId)
                                $('#edit_image_' + imageId).attr('data-title', response.title).attr('data-alias', response.alias).attr('data-description', response.description).attr('data-link', response.link).attr('data-position', response.position);
                                $('#meta_image_' + imageId + ' #im_title').text(response.title);
                                $('#meta_image_' + imageId + ' #im_alias').text(response.alias);
                                $('#meta_image_' + imageId + ' #im_description').text(response.description);
                                $('#meta_image_' + imageId + ' #im_link').text(response.link);
                                $('#meta_image_' + imageId + ' #im_position').text(response.position);
                            }
                        }, 'json');
                    }
                }
            })
        });




        // сортировка галереи
        $("#fileList").sortable({
            items: "> figure.gallery-item",
            opacity: 0.5,
            revert: true,
            scroll: true,
            tolerance: "pointer",
            handle: ".move_zone",
            cursor: "move",
            scrollSensitivity: 50,
            scrollSpeed: 50,
            forcePlaceholderSize: true,
            connectWith: '.gallery-product',
            placeholder: "gallery-sortable",
            stop : function () {
                $('.btn-sorting').addClass('show');
            }
        }).disableSelection();
        // применить сортировку галереи
        $(document).on("click", ".btn-sorting" , function() {
            var module = $(this).attr('data-module'), action = $(this).attr('data-action');
            var ids = new Array();
            $('#fileList figure.gallery-item-images').each(function() {
                ids.push($(this).attr("data-id"));
            });

            $.ajax({
                url: "{$adminUrl}/"+module,
                method: "POST",
                data: { imageIds: ids, action: action },
                success: function () {
                    $("#fileList").load(location.href + " figure.gallery-item-images");
                    new Noty({ text: 'Фотогалерея отсортирована', type: 'success' }).show();
                    $('.btn-sorting').removeClass('show');
                }
            });
        });

        // сортировка галереи
        $("#fileListBColors").sortable({
            items: "> figure.gallery-item",
            opacity: 0.5,
            revert: true,
            scroll: true,
            tolerance: "pointer",
            handle: ".move_zone",
            cursor: "move",
            scrollSensitivity: 50,
            scrollSpeed: 50,
            forcePlaceholderSize: true,
            connectWith: '.gallery-product',
            placeholder: "gallery-sortable",
            stop : function () {
                $('.btn-sorting-bcolor').addClass('show');
            }
        }).disableSelection();

        // применить сортировку галереи
        $(document).on("click", ".btn-sorting-bcolor" , function() {
            var ids = new Array();

            $('#fileListBColors figure.gallery-item').each(function() {
                ids.push($(this).attr("data-id"));
            });

            $.ajax({
                url: "{$adminUrl}/section?action=sortPictureBColors",
                method: "POST",
                data: { imageIds: ids },
                success: function () {
                    $("#fileListBColors").load(location.href + "fileListBColors figure.gallery-item-bcolor");
                    new Noty({ text: 'Отсортировано', type: 'success' }).show();
                    $('.btn-sorting-bcolor').removeClass('show');
                }
            });
        });

        // сортировка галереи
        $("#fileListIColors").sortable({
            items: "> figure.gallery-item",
            opacity: 0.5,
            revert: true,
            scroll: true,
            tolerance: "pointer",
            handle: ".move_zone",
            cursor: "move",
            scrollSensitivity: 50,
            scrollSpeed: 50,
            forcePlaceholderSize: true,
            connectWith: '.gallery-product',
            placeholder: "gallery-sortable",
            stop : function () {
                $('.btn-sorting-icolor').addClass('show');
            }
        }).disableSelection();
        // применить сортировку галереи
        $(document).on("click", ".btn-sorting-icolor" , function() {
            var ids = new Array();

            $('#fileListIColors figure.gallery-item').each(function() {
                ids.push($(this).attr("data-id"));
            });

            $.ajax({
                url: "{$adminUrl}/section?action=sortPictureIColors",
                method: "POST",
                data: { imageIds: ids },
                success: function () {
                    $("#fileListIColors").load(location.href + "fileListIColors figure.gallery-item-icolor");
                    new Noty({ text: 'Отсортировано', type: 'success' }).show();
                    $('.btn-sorting-icolor').removeClass('show');
                }
            });
        });



        $(document).on('click', '#enableIcon', function(){
            if (!$(this).is(':checked'))
                $('#icon').val('');
        });

        $('#selectUrlType').change(function(){
            console.log($('#selectUrlType').val())
            if($('#selectUrlType').val() === 'external') {
	            if (!$("#icon-urlType").hasClass("show"))
                    $('#icon-urlType').addClass("show");
            } else {
                if ($("#icon-urlType").hasClass("show"))
                    $('#icon-urlType').removeClass("show");

            }
        });


    });

</script>


