<!-- Page header -->
<div class="page-header page-header-light">
	<div class="page-header-content header-elements-md-inline">
		<div class="page-title d-flex">
			<h4><i class="icon-arrow-left52 mr-2"></i> <span class="font-weight-semibold">{$title}</span></h4>
			<a href="#" class="header-elements-toggle text-default d-md-none"><i class="icon-more"></i></a>
		</div>

		<div class="header-elements d-none">
			<div class="d-flex justify-content-center">
				<a class="btn btn-sm btn-primary" data-popup="popover-solid" data-trigger="hover" title="{general:add}" data-placement="top" href="{$adminUrl}/section?action=add{if isset($page)}&page={$page}{/if}{if isset($parentId)}&parentId={$parentId}{/if}"><i class="icon-plus3"></i></a>
			</div>
		</div>
	</div>

	<div class="breadcrumb-line breadcrumb-line-light header-elements-md-inline">
		<div class="d-flex">
			<div class="breadcrumb">
				<a href="{$adminUrl}/overview" class="breadcrumb-item"><i class="icon-home2 mr-2"></i> Статистика</a>
				<a href="{$adminUrl}/sections" class="breadcrumb-item">{$title} </a>
                {if isset($parent)}
                    <a class="breadcrumb-item" href="{$adminUrl}/sections"><i class="icon-clippy"></i> {sections:upToRoot}</a>
                    {if isset($parent->parentId)}
                        <a class="breadcrumb-item" href="{$adminUrl}/sections?parentId={$parent->parentId}">{if isset($parent->name)}<i class="icon-clippy"></i> {$parent->name}{/if}</a>
                    {/if}
                {/if}
			</div>

			<a href="#" class="header-elements-toggle text-default d-md-none"><i class="icon-more"></i></a>
		</div>

		<div class="header-elements d-none">
			<div class="breadcrumb justify-content-center">
                {include file="module/show-by.tpl" url="{$adminUrl}/sections"}
			</div>
		</div>
	</div>
</div>

<div class="content">
    <div class="row">
    	<div class="col-md-12">

            {if isset($action) && $action == 'confirmDelete'}
			    <div class="card">
				    <div class="alert bg-danger text-white alert-dismissible m-0">
					    <span class="font-weight-semibold">{sections:deleting} "{if isset($section.name)}{$section.name nofilter}{/if}"</span><br />
					    <span>{sections:deleteSectionQuestion}?</span>
				    </div>
			    </div>
	            <div class="card">
	                <form action="{$adminUrl}/sections" method="post" id="confirmDelete">
	                    <div class="card-body">
	                        <input type="hidden" name="id" value="{if isset($section.sectionId)}{$section.sectionId}{/if}" />
	                        <input type="hidden" name="parentId" value="{if isset($parentId)}{$parentId}{/if}" />
		                    <div class="row">
		                        {if isset($section.hasSubsections) || isset($section.hasArticles)}
	                                {if isset($subsectionOptions)}
				                        <div class="{if isset($articleOptions)}col-md-6{else}col-md-12{/if}">
					                        <div class="form-group">
							                        <label class="form-group-float-label is-visible">{sections:subsectionsAndArticles}</label>
	                                            {html_options options=$subsectionOptions name="param[moveSubsectionsTo]" class="form-control form-control-sm select"}
					                        </div>
				                        </div>
	                                {/if}
		                            {if isset($articleOptions)}
					                    <div class="{if isset($subsectionOptions)}col-md-6{else}col-md-12{/if}">
			                                <div class="form-group">
			                                    <label class="form-group-float-label is-visible">{articles:title}</label>
			                                    {html_options options=$articleOptions name="param[moveArticlesTo]" class="form-control form-control-sm select"}
			                                </div>
					                    </div>
		                            {/if}

		                        {/if}
		                    </div>
	                    </div>
	                    <div class="card-footer bg-white d-sm-flex justify-content-sm-between align-items-sm-center">
	                        <button class="btn btn-sm btn-primary" type="submit" name="action" value="deleteConfirmed">{general:yes}</button>
	                        <a class="btn btn-sm btn-light" href="{$adminUrl}/sections?parentId={$parentId}">{general:cancel}</a>
	                    </div>
	                </form>
	            </div>

		    {else}

			    <div class="card">
		            <div class="">
	                    <table class="table table-togglable table-xs table-striped table-hover" id="sections">
	                    <thead>
	                        <tr>
		                        <th data-hide="phone, tablet" class="text-center" width="30">#</th>
	                            <th data-toggle="true" class="">{general:table:name}</th>
	                            <th data-hide="phone, tablet">{general:table:alias}</th>
	                            <th data-hide="phone, tablet">{general:table:path}</th>
	                            <th data-hide="phone, tablet" width="80">{general:table:type}</th>
	                            <th data-hide="phone, tablet" width="140">{general:table:typeContent}</th>
	                            <th class="text-center text-muted" width="50"><i class="icon-checkmark3"></i></th>
	                        </tr>
	                    </thead>
	                    {if isset($sections)}
	                        <tbody class="selectable-demo-list sections_list" id="section_list">
	                        {foreach item=section from=$sections name=sections}
	                            <tr id="section-{$section.sectionId}" data-id="{$section.sectionId}" class="{if $section.status eq 'hidden'}table-warning{/if}">
		                            <td class="move_zone text-nowrap"><i class="icon-menu8" data-popup="popover-solid" data-trigger="hover" title="Переместить" data-placement="top" style="opacity: 0.5"></i> </td>
	                                <td class="text-nowrap">
	                                    {if isset($section.hasSubsections)}
	                                        <a data-popup="popover-solid" data-trigger="hover" title="{$section.name}" data-placement="top" href="{$adminUrl}/sections?parentId={$section.sectionId}" style="border-bottom: 1px dashed;">{$section.name|strip_tags|truncate:25}</a>
	                                    {else}
		                                    <span data-popup="popover-solid" data-trigger="hover" title="{$section.name}" data-placement="top" >{$section.name|strip_tags|truncate:25}</span>
	                                    {/if}
	                                </td>
		                            <td class="text-nowrap"><span  data-popup="popover-solid" data-trigger="hover" title="{$section.alias}" data-placement="top">{$section.alias|strip_tags|truncate:25}</span></td>
	                                <td class="text-nowrap"><a href="{$section.url}" data-popup="popover-solid" data-trigger="hover" title="{general:view}" data-placement="top"  target="_blank">{if $section.fileName eq 'index'}/{else}/{$section.fileName}/{/if}</a></td>
	                                <td class="text-nowrap">{$section.typeName}</td>
	                                <td class="text-nowrap">{$section.typeContentName}</td>
	                                <td class="text-center">
	                                    <div class="list-icons">
		                                    <div class="list-icons-item">
			                                    <div class="form-check form-check-switchery" data-popup="popover-solid" data-trigger="hover" title="Добавить или скрыть в основном меню" data-placement="top">
				                                    <label class="form-check-label">
					                                    <input type="checkbox" class="form-check-input-switchery top_menu" data-fouc data-id="{$section.sectionId}" {if $section.topMenu eq '1'}checked{/if}>
				                                    </label>
			                                    </div>
		                                    </div>
		                                    <a class="list-icons-item text-primary-600" data-popup="popover-solid" data-trigger="hover" title="{general:edit}" data-placement="top" href="{$adminUrl}/section?action=edit&id={$section.sectionId}{if $parentId}&parentId={$parentId}{/if}{if isset($page)}&page={$page}{/if}"><i class="icon-pencil7"></i></a>
	                                        <div class="list-icons-item dropdown">
	                                            <a href="javascript:void('');" class="list-icons-item caret-0 dropdown-toggle" data-toggle="dropdown"><i class="icon-menu9"></i></a>
	                                            <div class="dropdown-menu dropdown-menu-right">
	{*                                                <a href="{$section.url}" target="_blank" class="dropdown-item"><i class="icon-rotate-ccw2"></i> {general:view}</a>*}
		                                            <a class="dropdown-item" href="{$adminUrl}/section?action=edit&id={$section.sectionId}{if $parentId}&parentId={$parentId}{/if}{if isset($page)}&page={$page}{/if}"><i class="icon-pencil7"></i> {general:edit}</a>
	                                                <a href="javascript:void('');" class="dropdown-item ajax_action {if $section.status eq 'visible'}active_class{/if}" data-module="sections" data-action="status" data-id="{$section.sectionId}"><i class="{if $section.status eq 'visible'}icon-eye{else}icon-eye-blocked{/if}"></i> {general:status}</a>
	                                                {if $section.fileName ne 'index'}
	                                                    <div class="dropdown-divider"></div>
	                                                    <a href="{$adminUrl}/sections?action=confirmDelete&id={$section.sectionId}{if $parentId}&parentId={$parentId}{/if}{if isset($page)}&page={$page}{/if}" class="dropdown-item"><i class="icon-cross2"></i> {general:delete}</a>
	                                                {/if}
	                                            </div>
	                                        </div>
	                                    </div>
	                                </td>
	                            </tr>
	                        {/foreach}


	                        </tbody>
	                    {else}
	                        <tbody><tr class="odd"><td class="data none" colspan="8" align="center">- {general:none} -</td></tr></tbody>
	                    {/if}
	                </table>
		            </div>
	                {include file="module/pagination.tpl" url="{$adminUrl}/sections" params="{if $parentId}&parentId={$parentId}{/if}"}
	            </div>

            {/if}
    	</div>
    </div>
</div>


<script>

    $(document).ready(function () {

        {if isset($errors.not_saved)} new Noty({ text: '{sections:errors:0}', type: 'error' }).show();{/if}
        {if isset($errors.section_not_found)} new Noty({ text: '{sections:errors:1}', type: 'error' }).show(); {/if}

        {if isset($messages.saved)} new Noty({ text: '{sections:messages:0}', type: 'success' }).show(); {/if}
        {if isset($messages.deleted)} new Noty({ text: '{sections:messages:1}', type: 'success' }).show(); {/if}
        {if isset($messages.sorted)} new Noty({ text: '{sections:messages:2}', type: 'success' }).show(); {/if}

    });

    function moveUpMessage(){ new Noty({ text: '{sections:messages:3}', type: 'warning' }).show(); }
    function moveDownMessage(){ new Noty({ text: '{sections:messages:4}', layout: 'topRight', type: 'warning' }).show(); }
    function topMenuMessage(){ new Noty({ text: '{sections:messages:6}', type: 'warning' }).show(); }
    function downMenuMessage(){ new Noty({ text: '{sections:messages:7}', type: 'warning' }).show(); }
    function sectionVisibleMessage(){ new Noty({ text: '{sections:messages:8}', type: 'warning' }).show(); }
    function sectionHiddenMessage(){ new Noty({ text: '{sections:messages:9}', type: 'warning' }).show(); }


    $(document).on('click', '.top_menu', function() {
        var id = $(this).attr("data-id");
        $.post("{$adminUrl}/sections?action=menu", { id: id }, function(data){
            console.log(data.check);
            if (data.check === 1) {
                $.jGrowl('{sections:messages:6} 👍', { theme: 'bg-primary alert-rounded', position: 'top-right', life: 1000 });
                {*new Noty({ text: '{sections:messages:6}', layout: 'topCenter', type: 'warning' }).show();*}
            } else{
                $.jGrowl('{sections:messages:7} 👍', { theme: 'bg-primary alert-rounded', position: 'top-right', life: 1000 });
                {*new Noty({ text: '{sections:messages:7}', layout: 'topCenter', type: 'warning' }).show();*}
            }
        }, 'json');
    });

    $("#section_list").sortable({
        items: "> tr",
        opacity: 0.5,
        revert: true,
        scroll: true,
        tolerance: "pointer",
        handle: ".move_zone",
        scrollSensitivity: 50,
        scrollSpeed: 50,
        cursor: "move",
        connectWith: '.sections_list',
        placeholder: "ui-sortable-handle",
        update	   : function(event, ui) {
		    var sectionIds = new Array();

            $('#section_list tr').each(function() {
                sectionIds.push($(this).attr("data-id"));
		    });

            console.log(sectionIds);
            $.ajax({
                url:"{$adminUrl}/sections?action=reorder",
                method:"POST",
                data:{ sectionIds: sectionIds },
                success:function(data) {
                    location.reload();
                    //alert(data);
                }
            });
	    }
    }).disableSelection();

</script>



