<div class="page-header page-header-light">
    <div class="page-header-content header-elements-md-inline">
        <div class="page-title d-flex">
            <h4><i class="icon-arrow-left52 mr-2"></i> <span class="font-weight-semibold">{$title}</span></h4>
            <a href="#" class="header-elements-toggle text-default d-md-none"><i class="icon-more"></i></a>
        </div>

        <div class="header-elements d-none">
            <div class="d-flex justify-content-center">

            </div>
        </div>
    </div>


    <div class="breadcrumb-line breadcrumb-line-light header-elements-md-inline">
        <div class="d-flex">
            <div class="breadcrumb">
                <a href="{$adminUrl}/overview" class="breadcrumb-item"><i class="icon-home2 mr-2"></i> Статистика</a>
                <a href="{$adminUrl}/visitors" class="breadcrumb-item">{$title}</a>
            </div>

            <a href="#" class="header-elements-toggle text-default d-md-none"><i class="icon-more"></i></a>
        </div>

        <div class="header-elements d-none">
            <div class="breadcrumb justify-content-center">
                {include file="module/show-by.tpl" url="{$adminUrl}/visitors"}
            </div>
        </div>
    </div>
</div>

<div class="content">
    <div class="row">
        <div class="col-md-12">
	        <div class="card">
		        {include file="stats/form/selectors.tpl" action="{$adminUrl}/visitors" select=''}
	        </div>

            <div class="card">
                <div class="card-header bg-white header-elements-sm-inline">
                    <h5 class="card-title">{$title}</h5>
                    <div class="header-elements">
                        <div class="list-icons">
                            <a class="list-icons-item" data-action="collapse"></a>
                        </div>
                    </div>
                </div>
	            <div class="">
                    <table class="table table-xs table-striped table-actions table-hover">
                    <thead>
                        <tr>
                            <th class="text-center">{stats:firstVisit}</th>
                            <th class="text-left">{stats:referer}</th>
                            <th class="text-center">{stats:visits}</th>
                        </tr>
                    </thead>
                    {if !empty($visitors)}
                        <tbody>
                            {foreach item=visitor from=$visitors}
                                <tr class="">
                                    <td class="text-nowrap">{$visitor->firstVisitOn}</td>
                                    <td class="text-left" width="100%">
                                        {if isset($visitor->refererWebsite)}
                                            <a href="{$visitor->referer}" target="_blank">{$visitor->refererWebsite|truncate:30}</a>
                                            {if isset($visitor->searchPhrase)} ({$visitor->searchPhrase|truncate:50}){/if}
                                        {elseif isset($visitor->refererUrl)}
                                            <a href="{$visitor->refererUrl}" target="_blank">{$visitor->refererUrl|truncate:80}</a>
                                        {/if}
                                    </td>
                                    <td class="text-center">
                                        <a href="{$adminUrl}/visitor?visitorId={$visitor->visitorId}{if isset($filterTypeId)}&filterTypeId={$filterTypeId}{/if}">{$visitor->totalVisits}</a>
                                    </td>

                                </tr>
                            {/foreach}
                        </tbody>
                        {else}
                            <tbody><tr class="odd"><td class="text-center" colspan="4">- {general:none} -</td></tr></tbody>
                        {/if}

                </table>
	            </div>
                {include file="module/pagination.tpl" url="{$adminUrl}/visitors" params="{if isset($filterTypeId)}&filterTypeId={$filterTypeId}{/if}{if isset($domain)}&domain={$domain}{/if}"}
            </div>
        </div>
    </div>
</div>
<!-- /content area -->