<!-- Page header -->
<div class="page-header page-header-light">
	<div class="page-header-content header-elements-md-inline">
		<div class="page-title d-flex">
			<h4><i class="icon-arrow-left52 mr-2"></i> <span class="font-weight-semibold">{$title}</span></h4>
			<a href="#" class="header-elements-toggle text-default d-md-none"><i class="icon-more"></i></a>
		</div>

		<div class="header-elements d-none">
			<div class="d-flex justify-content-center">
				<a class="btn btn-sm btn-primary mx-1" data-popup="popover-solid" data-trigger="hover" title="{general:add}" data-placement="top" href="{$adminUrl}/user?action=add{if !empty($page)}&page={$page}{/if}{$buildQueryString}"><i class="icon-plus3"></i></a>
			</div>
		</div>
	</div>

	<div class="breadcrumb-line breadcrumb-line-light header-elements-md-inline">
		<div class="d-flex">
			<div class="breadcrumb">
				<a href="{$adminUrl}/overview" class="breadcrumb-item"><i class="icon-home2 mr-2"></i> Статистика</a>
				<a href="{$adminUrl}/users" class="breadcrumb-item">{$title}</a>
			</div>

			<a href="#" class="header-elements-toggle text-default d-md-none"><i class="icon-more"></i></a>
		</div>

		<div class="header-elements d-none">
			<div class="breadcrumb justify-content-center">
                {include file="module/show-by.tpl" url="{$adminUrl}/users"}
			</div>
		</div>
	</div>
</div>
<!-- /page header -->


<!-- Content area -->
<div class="content">
    			
    <div class="row">
    	<div class="col-md-12">
            
            <div class="card">
	            <div class="">
	                <table class="table table-togglable table-xs table-striped table-hover users-archive" id="users">
	                    <thead>
	                        <tr>
	                            <th data-hide="ID" class="text-center" width="30">{users:table:id}</th>
	                            <th data-hide="phone" class="text-center" width="30">{users:table:date}</th>
	                            <th data-hide="image" class="">{users:table:login}</th>
	                            <th data-toggle="true">{users:table:email}</th>
	                            <th data-hide="phone" class="text-center">{general:status}</th>
	                            <th class="text-center text-muted" width="30"><i class="icon-checkmark3"></i></th>
	                        </tr>
	                    </thead>
	                    {if !empty($users)}
		                    <tbody>
		                        {foreach item=user from=$users name=users}
		                        <tr id="user-{$user.userId}" class="{if $user.status eq 'hidden'}table-warning{/if}">
		                            <td class="text-center" nowrap="nowrap">{$user.userId}</td>
		                            <td class="text-center" nowrap="nowrap">{$user.registered nofilter}</td>
		                            <td class="">{$user.loginName nofilter}</td>
		                            <td class="">{$user.email}</td>
		                            <td id="status-{$user.userId}" class="text-center">{$user.statusName nofilter}</td>
		                            <td class="text-center">
		                                <div class="list-icons">
			                                <a class="list-icons-item text-primary-600" data-popup="popover-solid" data-trigger="hover" title="{general:edit}" data-placement="top" href="{$adminUrl}/user?action=edit&id={$user.userId}{if !empty($page)}&page={$page}{/if}{$buildQueryString}"><i class="icon-pencil7"></i></a>
		                                    <div class="list-icons-item dropdown">
		                                        <a href="javascript:void('');" class="list-icons-item caret-0 dropdown-toggle" data-toggle="dropdown"><i class="icon-menu9"></i></a>
		                                        <div class="dropdown-menu dropdown-menu-right">
                                                    {if $user.status eq 4 or $user.status eq 5}
			                                        <a class="dropdown-item" id="user-approve-{$user.userId}" href="javascript:void('')" style="color: #ec407a;" onclick="return approve({$user.userId}, 'users');"><i class="icon-thumbs-up2"></i> {general:approve}</a>
		                                            {/if}
		                                            <a class="dropdown-item" href="{$adminUrl}/user?action=edit&id={$user.userId}&page={$page}{$buildQueryString}"><i class="icon-pencil7"></i> {general:edit}</a>
		                                            <div class="dropdown-divider"></div>
		                                            <a href="javascript:void('');" class="dropdown-item"  onclick="remove({$user.userId}, '{$user.loginName}', 'users')"><i class="icon-cross2"></i> {general:delete}</a>
		                                        </div>
		                                    </div>
		                                </div>
		                            </td>
		                        </tr>
		                        {/foreach}

		                    </tbody>
	                    {else}
	                        <tbody><tr class="odd"><td class="text-center" colspan="8">- {general:none} -</td></tr></tbody>
	                    {/if}
	                </table>
	            </div>
                {include file="module/pagination.tpl" url="{$adminUrl}/users" params="{$buildQueryString}"}

            </div>
    	</div>
    
    </div>
</div>

<script>

    function deleteImageMessage(){ new Noty({ text: '{users:messages:2}', type: 'success', timeout: 1500 }).show(); }
    function deleteMessage(){ new Noty({  text: '{users:messages:1}', type: 'success', timeout: 1500 }).show(); }
    function userNotFound(){ new Noty({ text: '{managers:errors:1}', type: 'error' }).show(); }
    function notDeleteAdministrator(){ new Noty({ text: '{managers:errors:6}', type: 'error' }).show(); }
    function notDeleteDeveloper(){ new Noty({ text: '{managers:errors:14}', type: 'error' }).show(); }
    function notDeleteFound(){ new Noty({ text: '{users:errors:17}', type: 'error' }).show(); }


</script>




