<?php

namespace Mnv\Core;

use Mnv\Core\Test\Logger;
use Mnv\Core\Managers\AdminAuth;
use Mnv\Core\Managers\Exceptions\UnknownIdException;

use Mnv\Models\Comments;
use Mnv\Models\Users\UserGroups;
use Mnv\Models\Users\UserTypes;

/**
 * Class AdminMnv
 */
abstract class AdminMnv extends Mnv
{

    /** @var Managers $managers */
    protected $manager;

    public string $adminUrl = '/admin';

    /** Mnv constructor. */
    public function __construct()
    {
        global $LANGUAGES;

        parent::__construct();

        try {
            $authAdmin = new AdminAuth(UserInfo::get_ip(), true, 60 * 5);
            $access         = new Menu();

            if (!empty(SITE_LANG)) {
                $this->adminUrl = '/admin/' . SITE_LANG;
            }

            if ($authAdmin->check()) {
                try {
                    if ($authAdmin->admin()->doesUserHaveRole($authAdmin->getUserId(), UserGroups::arrayGroup())) {

                        $this->manager = Managers::init()->adminManager($authAdmin->getUserId());
                        $access->getMenu($this->manager, $this->smarty);

                        /** получить количество ожидающих комментариев и сами комментарии для   */
                        if (Config::getValue('comments_enabled')) {
                            $pendingComments = new Comments();
                            if ($this->manager->userType === UserTypes::ADMIN || $this->manager->userType === UserTypes::DEVELOPER) {
                                $totalPendingComments = $pendingComments->totalPendingComments();
                                $comments = $pendingComments->getPendingComments();
                            }
                            $this->smarty->assign('totalPendingComments', empty($totalPendingComments) ? 0 : $totalPendingComments);
                            $this->smarty->assign('comments', empty($comments) ? 0 : $comments);
                        }

                        /** определение языка по умолчанию */
                        if (!is_null($LANGUAGES)) {
                            foreach ($LANGUAGES as $codename => $tmpLang) {
                                $LANGUAGES[$codename] = $tmpLang;
                                $LANGUAGES[$codename]['languageTransName'] = lang('languageList:'.$codename);
                                if ($tmpLang['isDefault']) {
                                    $this->smarty->assign('DEFAULT_LANG', $codename);
                                }
                            }
                        }
                    } else {
                        $authAdmin->logOut();
                    }
                } catch (UnknownIdException $e) {
                    $authAdmin->logOut();
                }
            } else {
                $authAdmin->logOut();
            }

            if (!$authAdmin->isLoggedIn() || !$authAdmin->hasAnyRole(UserGroups::arrayGroup())) {
                redirect($this->adminUrl . '/auth');
            }

            /** Максимальный размер загружаемого файла */
            $this->smarty->assign('upload_max_filesize',  $this->upload_max_filesize());
            /** default admin url */
            $this->smarty->assign('adminUrl',  $this->adminUrl);
            $this->smarty->assign('adminManager', $this->manager);
            /** statuses */
            $this->smarty->assign('statuses', lang('general:statuses'));

        } catch (Database\Throwable\IntegrityConstraintViolationException | Managers\Errors\AuthError $e) {
            $this->smarty->assign('error',  $e->getMessage());
        }
    }


    protected function upload_max_filesize(): string
    {
        $max_upload = str_replace( array ('M', 'm' ), '', @ini_get( 'upload_max_filesize' ) );
        return formatsize( $max_upload * 1024 * 1024 );
    }

}