<?php


namespace Mnv\Core\Files;


use League\Flysystem\Filesystem;
use League\Flysystem\Local\LocalFilesystemAdapter;
use League\Flysystem\UnixVisibility\PortableVisibilityConverter;

class FilesystemController
{
    public static $filesystem;

    public static function init($path): Filesystem
    {
        $visibilityConverter = PortableVisibilityConverter::fromArray([
            'file' => [
                'public' => 0666,
                'private' => 0644
            ],
            'dir' => [
                'public' => 0777,
                'private' => 0755
            ],
        ]);


        $adapter = new LocalFilesystemAdapter( UPLOAD_ROOT . $path, $visibilityConverter, LOCK_EX, LocalFilesystemAdapter::DISALLOW_LINKS );
        self::$filesystem = new Filesystem($adapter, ['directory_visibility' => 'public', 'visibility' => 'public']);

        return self::$filesystem;

    }

}