<?php


namespace Mnv\Core;


class Helpers
{

    use \Mnv\Core\Singleton\SingletonTrait;

    /**
     * @return array
     */
    public function getThemes(): array
    {
        $dh = opendir(GLOBAL_ROOT.'/themes');
        while ($item = readdir($dh)) {
            if ($item !== '.' && $item !== '..' && $item !== 'assets' && is_dir(GLOBAL_ROOT . "/themes/$item")) {
                $themes[] = $item;
            }
        }
        sort($themes);
        closedir($dh);

        return $themes;
    }

    /**
     * Блокировка не желательных пользователей (или взломщиков)
     *
     * @param $visitorIp
     * @return string|null
     */
    public function dieIfBanned($visitorIp): ?string
    {
        $result = null;
        if ($ban = DB::init()->connect()->table('users_banned_ips')->where('visitorIp', $visitorIp)->get()) {
            if (strtotime($ban->expiresOn) <= time()) {
                DB::init()->connect()->table('users_banned_ips')->where('visitorIp', $ban->visitorIp)->delete();
            } else {
                $result = "Your IP has been banned until $ban->expiresOn.";
            }
        }

        return $result;
    }

    /**
     * @param int $skipId
     * @param int $maxDepth
     * @param string $prefix
     * @param string $separator
     * @return array
     */
    public function getAllSectionOptions(int $skipId = 0, int $maxDepth = 99, $prefix = '', $separator = ' - '): array
    {
        global $SECTIONS;

        if (empty($SECTIONS)) {
            return array();
        }

        $skipChildren = array();
        $options = array(0 => lang('general:selectedSection'));
        foreach ($SECTIONS as $section) {
            if ($section['sectionId'] === $skipId) {
                if (!empty($section['allChildren'])) {
                    $skipChildren = $section['allChildren'];
                }
                continue;
            }
            if (in_array($section['sectionId'], $skipChildren, true)) {
                continue;
            }
            if ($section['level'] > $maxDepth) {
                continue;
            }

            $option = '';
            if (!empty($section['parents'])) {
                foreach ($section['parents'] as $parentId) {
                    if (!empty($SECTIONS[$parentId])) {
                        $option .= $separator;
                    } // $option .= /*$SECTIONS[$parentId]->name.*/ $separator;
                }
            }
            $option .= $section['name'];
            $options[$section['sectionId']] = $option;
        }

        if (count($options) === 1) return array();

        return $options;
    }

    /**
     * @param int $skipId
     * @param int $maxDepth
     * @param string $prefix
     * @param string $separator
     * @return array
     */
    public function getSectionOptions(int $skipId = 0, int $maxDepth = 99, $prefix = '', $separator = ' - '): array
    {
        global $SECTIONS;

        if (empty($SECTIONS)) {
            return array();
        }

        $skipChildren = array();
        $options = array(0 => lang('general:selectedSection'));
        foreach ($SECTIONS as $section) {
            if ($section['type'] === 'plain') {
                continue;
            }
            if ($section['sectionId'] === $skipId) {
                if (!empty($section['allChildren'])) {
                    $skipChildren = $section['allChildren'];
                }
                continue;
            }
            if (in_array($section['sectionId'], $skipChildren, true)) {
                continue;
            }
            if ($section['level'] > $maxDepth) {
                continue;
            }

            $option = '';
            if (!empty($section['parents'])) {
                foreach ($section['parents'] as $parentId) {
                    if (!empty($SECTIONS[$parentId])) {
                        $option .= $separator;
                    } // $option .= /*$SECTIONS[$parentId]->name.*/ $separator;
                }
            }
            $option .= $section['name'];
            $options[$section['sectionId']] = $option;
        }

        if (count($options) === 1) {
            return array();
        }

        return $options;
    }

    /**
     * @param int|null $skipId
     * @param string|null $typeContent
     * @param int|null $maxDepth
     * @param string|null $separator
     * @return array
     */
    public function getSectionContent(?int $skipId, ?string $typeContent, ?int $maxDepth = 99, ?string $separator = ' - '): array
    {
        global $SECTIONS;

        if (empty($SECTIONS)) return array();

        $skipChildren = array();
        $options = array(0 => lang('general:selectedSection'));
        foreach ($SECTIONS as $section) {
            if ($section['type'] === 'plain') {
                continue;
            }
            if ($section['sectionId'] === $skipId || (!is_null($typeContent) && $section['typeContent'] !== $typeContent)) {
                if (!empty($section['allChildren'])) {
                    $skipChildren = $section['allChildren'];
                }
                continue;
            }
            if (in_array($section['sectionId'], $skipChildren, true)) {
                continue;
            }
            if ($section['level'] > $maxDepth) {
                continue;
            }

            $option = '';
            if (!empty($section['parents'])) {
                foreach ($section['parents'] as $parentId) {
                    if (!empty($SECTIONS[$parentId])) {
                        $option .= $separator;
                    } // $option .= $SECTIONS[$parentId]->name . $separator
                }
            }
            $option .= $section['name'];
            $options[$section['sectionId']] = $option;
        }

        if (count($options) === 1) {
            return array();
        }

        return $options;
    }


    /**
     * @param int|null $skipId
     * @param string|null $typeContent
     * @param int|null $maxDepth
     * @return array
     */
    public function getSectionTypeContent(?string $typeContent, ?int $skipId, ?int $maxDepth = 99): array
    {
        global $SECTIONS;

        if (empty($SECTIONS)) {
            return array();
        }

        $skipChildren = array();
        $options = array(0 => lang('general:selectedSection'));
        foreach ($SECTIONS as $section) {
            if($section['type'] === 'plain') {
                continue;
            }
            if ($section['sectionId'] === $skipId || (!is_null($typeContent) && $section['typeContent'] !== $typeContent)) {
                if (!empty($section['allChildren'])) {
                    $skipChildren = $section['allChildren'];
                }
                continue;
            }
            if (in_array($section['sectionId'], $skipChildren, true)) {
                continue;
            }
            if ($section['level'] > $maxDepth) {
                continue;
            }

            $option = '';
            $option .= $section['name'];
            $options[$section['sectionId']] = $option;
        }

        if (count($options) === 1) {
            return array();
        }

        return $options;
    }

    /**
     * @param int $skipId
     * @param int $maxDepth
     * @param string $separator
     * @return array
     */
    public function getSectionContentNotTypeContent($skipId = 0, $maxDepth = 99, $separator = ' - '): array
    {
        global $SECTIONS;

        if (empty($SECTIONS)) return array();

        $skipChildren = array();
        $options = array(0 => lang('general:selectedSection'));
        foreach ($SECTIONS as $section) {
            if ($section['sectionId'] === $skipId) {
                if (!empty($section['allChildren'])) {
                    $skipChildren = $section['allChildren'];
                }
                continue;
            }
            if (in_array($section['sectionId'], $skipChildren, true)) {
                continue;
            }
            if ($section['level'] > $maxDepth) {
                continue;
            }

            $option = '';
            if (!empty($section['parents'])) {
                foreach ($section['parents'] as $parentId) {
                    if (!empty($SECTIONS[$parentId])) {
                        $option .= $SECTIONS[$parentId]['name'] . $separator;
                    }
                }
            }
            $option .= $section['name'];
            $options[$section['sectionId']] = $option;
        }

        if (count($options) === 1) {
            return array();
        }

        return $options;
    }



    /**
     * @param $date
     * @return false|string
     */
    public function dateFormation($date)
    {


//        $date['publishedOn'] = $date['Year'] . '-' . $date['Month'] . '-' . $date['Day'] . ' ' . $date['Hour'] . ':' . $date['Minute'] .':00';
//        if (!empty($date['Meridian'])) $date['publishedOn'] .= " $date[Meridian]";

        return date('Y-m-d H:i:s', strtotime($date));
    }

}