<?php

namespace Mnv\Core\Managers;

use Mnv\Core\DB;

final class Role {

    const DEVELOPER     = 1;    // РАЗРАБОТЧИК
    const MANAGER       = 2;    // МЕНЕДЖЕР
    const ADMIN         = 4;    // АДМИНИСТРАТОР
    const MODERATOR     = 8;    // МОДЕРАТОР
    const EDITOR        = 16;   // РЕДАКТОР
    const WRITER        = 32;   // ПИСАТЕЛЬ
    const SUBSCRIBER    = 64;   // ПОДПИСЧИК
    const CONSUMER      = 128;  // ПОТРЕБИТЕЛЬ

	/**
	 * Возвращает массив, сопоставляющий числовые значения ролей с их описательными именами.
	 *
	 * @return array
	 */
	public static function getMap()
    {
		$reflectionClass = new \ReflectionClass(Role::class);

		return \array_flip($reflectionClass->getConstants());
	}

	/**
	 * Возвращает описательные имена ролей
	 *
	 * @return string[]
	 */
	public static function getNames()
    {
		$reflectionClass = new \ReflectionClass(Role::class);

		return \array_keys($reflectionClass->getConstants());
	}

	/**
	 * Возвращает числовые значения роли
	 *
	 * @return int[]
	 */
	public static function getValues()
    {
		$reflectionClass = new \ReflectionClass(Role::class);

		return \array_values($reflectionClass->getConstants());
	}

	private function __construct() {}


//    public function getRoleAdmin($role) {
//
//        if (in_array($role, [Role::ADMIN, Role::MODERATOR, Role::EDITOR, Role::WRITER])) {
//            DB::init()->connect()->notIn('accessLevel', [Role::DEVELOPER,Role::MANAGER]);
//        }
//    }

}
