<?php

namespace Mnv\Core;


use Mnv\Core\Utilities\Cookie\Cookie;

/**
 * Class Mnv
 * @package Mnv\Models
 */
class Mnv
{
    /** @var Design  */
    public Design $smarty;

    /** @var array|mixed|null  */
    public $config = array();

    /** @var string $action */
    protected string $action;

    /** @var string $module */
    protected string $module;

    /** @var string $status */
    protected string $status;
    /** @var string  */
    protected string $query;
    /** @var int  */
    protected int $filterSection;

    /** @var int $page */
    protected int $page = 1;

    /** @var int $limit */
    protected int $limit = 20;

    /** @var string $notice */
    public string $notice = '';

    /** @var array $errors */
    public array $errors = array();

    /** @var array $messages */
    public array $messages = array();

    /** @var array $response */
    public array $response = array();

    /** @var string  */
    public string $buildQueryString = '';

    /** @var array  */
    private array $params = [];


    /** Mnv constructor. */
    public function __construct()
    {

        $this->config       = Config::init()->config();
        $this->smarty       = Design::init()->design();

        /** модуль */
        $this->module = getRequestVar('mod','');
//        print_r($this->module);
        /** постраничная навигация / по умолчанию страница 1 */
        $dsCookieName = 'limitSelector';
        $dsCookie     = getRequestVar($dsCookieName, '',  true,  true);

        /** action */
        $this->action = getRequestVar('action');
        /** постраничная навигация / по умолчанию страница 1 */
        $this->page   = (int) getRequestVar('page', 1);
        $newLimit     = (int) getRequestVar('limit');

        /** фильтрация статей */
        $this->filterSection = (int) getRequestVar('sctn', null, '', true);
        $this->query         = getRequestVar('query', '');
        $this->status        = getRequestVar('sts', '');

        if (!empty($dsCookie)) {
            $dsCookie = @unserialize($dsCookie);
        }

        if (!empty($newLimit)) {
            $this->limit = $newLimit;
            $dsCookie['limit'] = $newLimit;
            Cookie::setcookie($dsCookieName, serialize($dsCookie), time() + 60*60*24*180);

        } elseif (!empty($dsCookie['limit'])) {
            $this->limit = $dsCookie['limit'];
        }

        /** dates */
        $this->smarty->assign('adjustedNow', adjustTime(gmdate('Y-m-d H:i:s')));

        if (!empty($this->query)) {
            $this->params['query'] = $this->query;
        }

        if (!empty($this->filterSection)) {
            $this->params['sctn'] = $this->filterSection;
        }

        if (!empty($this->status)) {
            $this->params['sts'] = $this->status;
        }

        $this->smarty->assign('page', $this->page);
        $this->smarty->assign('limit', $this->limit);



        $this->smarty->assign('buildQueryString', !empty($this->params) ? '&' . http_build_query(array_filter($this->params)) : '');

        if (!empty($this->errors)) {
            $this->smarty->assign('errors', $this->errors);
        }
        if (!empty($this->messages)) {
            $this->smarty->assign('messages', $this->messages);
        }

    }

    /**
     * @param array $params
     * @return string|null
     */
    protected function buildQueryString(array $params): ?string
    {
        $result = array_merge($params, $this->params);

        var_dump($result);

        $this->buildQueryString = !empty($result) ? http_build_query(array_filter($result)) : '';

        return $this->buildQueryString;
    }


}