<?php

namespace Mnv\Models;

use Mnv\Core\DB;
use Mnv\Core\Mnv;
use Mnv\Core\Files\Image\ImageSizes;

/**
 * Class BannerImages
 * @package Mnv\Models
 */
class BannerImages extends Mnv
{

    private static $_table  = 'banners_images';
    private static $_files = 'files';

    public $banners;
    public $banner;
    public $bannerId;
    public $total;


    /**
     * SlidersAdmin constructor.
     */
    public function __construct()
    {
        parent::__construct();
    }


    public function getGroupName($groupId)
    {
        return DB::init()->connect()->table('banners_group')->select('name')->where('groupId', $groupId)->getValue();
    }

    /**
     * @return int|mixed
     */
    public function getAll(): void
    {
        $this->banners = DB::init()->connect()->table(static::$_table)->orderBy('orderBy')->getAll('array');

        $this->total();

    }

    public function total(): void
    {
        $this->total = DB::init()->connect()->table(static::$_table)->count('*', 'count')->getValue();
    }


    public function edit(): void
    {
        if (($this->banner = DB::init()->connect()->table(static::$_table)->where('bannerId', $this->bannerId)->get('array'))
            && !empty($this->banner['fileId']) && $this->banner['fileId'] > 0) {
            $this->banner['image'] = $this->get_image($this->banner['fileId']);
        }
    }

    /**
     * Получение картинок к слайду
     *
     * @param int $fileId
     * @return ImageSizes|null
     */
    public function get_image(int $fileId): ?ImageSizes
    {
        if ($file = DB::init()->connect()->table(static::$_files)->where('fileId', $fileId)->get()) {
            return ImageSizes::init()->get(null, $file);
        }

        return null;
    }

    /**
     * Новый слайд
     * @param $banner
     * @return bool
     */
    public function add($banner): bool
    {
        $banner['orderBy'] = DB::init()->connect()->table(static::$_table)->max('orderBy')->getValue() + 1;
        if ($this->bannerId = DB::init()->connect()->table(static::$_table)->insert((array)$banner)) {
            return true;
        }

        return false;
    }

    /**
     * Обновление слайда
     *
     * @param $banner
     * @return bool
     */
    public function update($banner): bool
    {
        if (!empty($this->bannerId) && DB::init()->connect()->table(static::$_table)->where('bannerId', $this->bannerId)->update((array)$banner)) {
            $this->edit();

            return true;
        }
        return false;
    }




    /**
     * удалене картинка слайда
     * @param int|null $bannerId
     * @return bool
     */
    public function deleteImage(?int $bannerId): bool
    {
        if ($bannerId !== null) {
            DB::init()->connect()->table(static::$_table)->where('bannerId', $bannerId)->update(['fileId' => 0]);
            return true;
        }
        return false;
    }

    /**
     * Сортировка слайдов
     *
     * @param $bannerIds
     */
    public function reorder($bannerIds)
    {
        $i = 0;
        foreach ($bannerIds as $bannerId) {
            $i++;
            DB::init()->connect()->table(self::$_table)->where('bannerId', $bannerId)->update(['orderBy' => $i]);
        }
    }

    /**
     * Скрать / показать раздел
     *
     * @return array
     */
    public function status(): array
    {
        if (!empty($this->bannerId)) {
            if ($olrBannerStatus = DB::init()->connect()->table(static::$_table)->select('status')->where('bannerId', $this->bannerId)->getValue()) {
                $sliderUpdate['status'] = ($olrBannerStatus == 'visible') ? 'hidden' : 'visible';
                DB::init()->connect()->table(static::$_table)->where('bannerId', $this->bannerId)->update($sliderUpdate);
                return array('data' => true, 'status' => $sliderUpdate['status']);
            }

            return array('data' => false);
        }

        return array('data' => false);
    }

    /**
     * удаление слайда
     *
     * @return bool
     */
    public function remove(): bool
    {
        return !empty($this->bannerId) && DB::init()->connect()->table(static::$_table)->where('bannerId', $this->bannerId)->delete();
    }

}