<?php

namespace Mnv\Models\Contents;

use Mnv\Core\AdminMnv;
use Mnv\Core\DB;
use Mnv\Core\Files\Image\ImageSizes;

/**
 * Class AbstractContent
 * @package Mnv\Models\Contents
 */
abstract class AbstractContent extends AdminMnv
{

    /** @var $contents */
    public $contents;

    /** @var int  */
    public int $total = 0;

    /** @var $content */
    public $content;

    /** @var int */
    public int $articleId;

    /** @var $result */
    public $result;

    /** @var $image */
    public $image;

    /** @var int $imageId */
    public int $imageId;

    public string $typeContent;
    public array $filter;
    /**
     * фильтрация / сортировка контента
     */
    protected function sorting(): void
    {
        global $SECTIONS;

        if (!empty($this->typeContent)) {
            DB::init()->connect()->where('typeContent', $this->typeContent);
        }

        if (!empty($this->status)) {
            DB::init()->connect()->where('status', $this->status);
        }

        if (!empty($this->query)) {
            DB::init()->connect()->grouped(function($q) {
                $q->like('title', "%" . $this->query . "%")->orLike('content', "%" . $this->query . "%")->orLike('keywords',"%" . $this->query . "%");
            });
        }

        if (!empty($this->filterSection) && !empty($SECTIONS[$this->filterSection])) {
            $sectionIds = array($this->filterSection);
            if (!empty($SECTIONS[$this->filterSection]['allChildren'])) {
                $sectionIds = array_merge($sectionIds, $SECTIONS[$this->filterSection]['allChildren']);
            }
            DB::init()->connect()->in('sectionId', $sectionIds);
        }

        if (!empty($this->filter['dateStart']) && !empty($this->filter['dateEnd'])) {
            DB::init()->connect()->between('publishedOn', $this->filter['dateStart'], $this->filter['dateEnd']);
        }
    }

    abstract protected function listContent(?string $orderBy);

    abstract protected function total();

    abstract protected function getContent();

    abstract protected function remove();

    abstract protected function add(?array $content, ?array $images, int $managerId);

    abstract protected function update(?array $content, ?array $images, int $managerId);

    abstract protected function checkFileName(?string $fileName);

    abstract protected function approve();

    abstract protected function status();

//    abstract protected function reorder($ids, $articleIds);


    /**
     * получать основной картинки
     *
     * @param $articleId
     * @return ImageSizes|null
     */
    protected function getFile($articleId)
    {
        $articleImage = DB::init()->connect()->table('article_images')->select('fileId')->where('type', 'general')->where('articleId', $articleId)->get();
        if ($articleImage && $file = DB::init()->connect()->table('files')->select('*')->where('fileId', $articleImage->fileId)->get()) {
            return ImageSizes::init()->get($articleImage, $file);
        }

        return null;
    }


    /**
     * получать основной картинки
     */
    protected function getFiles(): void
    {
        if ($images = DB::init()->connect()->table('article_images')->select('*')->where('articleId', $this->articleId)->indexKey('imageId')->orderBy('orderBy')->getAllIndexes()) {
            foreach ($images as $imageId => $image) {
                if ($file = DB::init()->connect()->table('files')->where('fileId', $image->fileId)->get()) {
                    if ($image->type === 'general') {
                        $this->content['image'] = ImageSizes::init()->get($image, $file);
                    } elseif ($image->type === 'gallery') {
                        $this->content['gallery'][$imageId] = ImageSizes::init()->get($image, $file);
                    } else {
                        $this->content['docs'][$imageId] = ImageSizes::init()->get($image, $file);
                    }
                }
            }
        }
    }


}