<?php

namespace Mnv\Models;

use Mnv\Core\DB;
use Mnv\Core\Mnv;

class Countries extends Mnv
{
    private static $_table = 'geo_countries';

    public $countries;
    public $country;
    public $countryId;
    public $total;
    /**
     * SocialsAdmin constructor.
     */
    public function __construct()
    {
        parent::__construct();
    }


    public function getAll()
    {
        $this->countries = DB::init()->connect()->table(self::$_table)->select('*')->pagination($this->limit, $this->page)->orderBy('id')->getAll();

        foreach($this->countries as $key => $country) {
            $this->countries[$key]->status = lang('general:statuses:'.$country->status);
        }

    }

    /**
     * @return int
     */
    public function total()
    {
        $this->total = DB::init()->connect()->table(self::$_table)->count('*', 'count')->getValue();
    }


    public function edit()
    {
        if (!empty($this->countryId)) {
            $this->country = DB::init()->connect()->table(self::$_table)->where('id', $this->countryId)->get();
        }
    }

    /**
     * @param $region
     * @return bool
     */
    public function add($region): bool
    {
        if ($this->countryId = DB::init()->connect()->table(self::$_table)->insert((array)$region)) return true;

        return false;
    }

    /**
     * @param $region
     * @return bool
     */
    public function update($region): bool
    {
        if (DB::init()->connect()->table(self::$_table)->where('id', $this->countryId)->update((array)$region)) return true;

        return false;
    }

    public function remove(): bool
    {
        if (DB::init()->connect()->table(self::$_table)->where('id', $this->countryId)->delete()) return true;

        return false;
    }

    /**
     * Сортировка
     * @param $ids
     * @param $countryIds
     */
    public function reorder($ids, $countryIds)
    {
        foreach ($countryIds as $i => $countryId) {
            DB::init()->connect()->table(self::$_table)->where('id', $ids[$i])->update(['orderBy' => $countryId]);
        }

    }


    /**
     * @return array|false|mixed|string
     */
    public function getSelectCountries()
    {
        $countryList = array(0 => 'Выберите страну');
        $countryList += DB::init()->connect()->table(self::$_table)->select('id, name')->orderBy('name ASC')->indexKey('id')->valueKey('name')->getAllIndexes();

//        ksort($countryList);

        return $countryList;
    }


}