<?php

namespace Mnv\Models;

use Mnv\Core\DB;
use Mnv\Core\Mnv;

/**
 * Class Currencies
 * @package Mnv\Models
 */
class Currencies extends Mnv
{
    private static $_table = 'shop_currency';

    public $currencies;
    public $currency;
    public $currencyId;

    /**
     * CurrencyAdmin constructor.
     */
    public function __construct()
    {
        parent::__construct();
    }

    public function getAll(): void
    {
        $this->currencies = DB::init()->connect()->table(self::$_table)->orderBy('isDefault', 'DESC')->getAll('array');
    }


    public function edit()
    {
        if (isset($this->currencyId))	{
            $this->currency = DB::init()->connect()->table(self::$_table)->where('id',  $this->currencyId)->get('array');
        }
    }

    /**
     * TODO сделано
     * @param $currency
     * @return bool
     */
    public function add($currency): bool
    {
        if ($this->currencyId = DB::init()->connect()->table(self::$_table)->insert($currency)) {
            return true;
        }

        return false;
    }

    /**
     * TODO сделано
     * @param $currency
     * @return bool
     */
    public function update($currency): bool
    {
        return !empty($this->currencyId) && DB::init()->connect()->table(self::$_table)->where('id', $this->currencyId)->update($currency);
    }

    /**
     * Удаление курса
     *
     * @return bool
     */
    public function remove(): bool
    {
        return !empty($this->currencyId) && DB::init()->connect()->table(self::$_table)->where('id', $this->currencyId)->delete();
    }

    /**
     * Сортировка слайдов
     *
     * @param $currencyIds
     */
    public function reorder($currencyIds): void
    {

        $i = 0;
        foreach ($currencyIds as $currencyId) {
            $param = ($i == 0) ? 1 : 0;
            DB::init()->connect()->table(self::$_table)->where('id', $currencyId)->update(['isDefault' => $param]);
            $i++;
        }
    }



    public function getDefaultCurrency()
    {
        return DB::init()->connect()->table(self::$_table)->where('isDefault',1)->get();
    }


    public function setDefaultCurrency(): bool
    {
        DB::init()->connect()->table(self::$_table)->where('isDefault',  1)->update(['isDefault' => 0]);
        DB::init()->connect()->table(self::$_table)->where('id',  $this->currencyId)->update(['isDefault' => 1]);

        return true;
    }


}