<?php

namespace Mnv\Models\Sections;

use Mnv\Core\DB;
use Mnv\Core\AdminMnv;
use Mnv\Core\Files\Image\ImageSizes;

/**
 * Class SectionAbstract
 * @package Mnv\Models\Sections
 */
abstract class SectionAbstract extends AdminMnv
{

    /** @var $sections */
    public $sections;

    /** @var $section */
    public $section;

    /** @var int  */
    public int $sectionId;
    /** @var int  */
    public int $parentId = 0;

    /** @var int  */
    public int $total;

    /** @var  */
    public $images;

    /** @var */
    public $param;

    /** @var array  */
    public array $result;

    abstract protected function listSections();
    abstract protected function total();
    abstract protected function get();
    abstract protected function edit();
    abstract protected function add(array $section, ?array $images, int $managerId);
    abstract protected function update(array $section, $oldSection, ?array $images, int $managerId);
    abstract protected function confirmDelete();
    abstract protected function deleteConfirmed($param);
    abstract protected function reorderSections($ids, $sectionIds);

    /**
     * получать файлы
     */
    public function getFiles(): void
    {
        $images = DB::init()->connect()->table('section_images')->select('*')->where('sectionId', $this->sectionId)->orderBy('orderBy')->getAll();

        if (!empty($images)) {
            foreach ($images as $imageId => $image) {
                if ($file = DB::init()->connect()->table('files')->where('fileId', $image->fileId)->get()) {
                    if ($image->type === 'general') {
                        $this->section['image'] = ImageSizes::init()->get($image, $file);
                    } else if ($image->type === 'gallery') {
                        $this->section['gallery'][$imageId] = ImageSizes::init()->get($image, $file);
                    } else {
                        $this->section['docs'][$imageId]    = ImageSizes::init()->get($image, $file);
                    }
                }
            }
        }
    }


    /**
     * Добавление картинки к контенту
     *
     * @param $sectionId
     * @param $images
     * @return bool
     */
    protected function general($sectionId, $images): bool
    {

        if (!empty($images['fileId'])) {
            if ($file = DB::init()->connect()->table('files')->where('fileId', $images['fileId'])->get()) {

                if ($imageId = DB::init()->connect()->table('section_images')->where('type', 'general')->where('sectionId', $sectionId)->select('imageId')->getValue()) {
                    $imageUpload['imageId'] = $imageId;
                }

                $imageUpload = [
                    'sectionId' => $sectionId,
                    'fileId'    => $file->fileId,
                    'type'      => 'general',
                    'orderBy'   => 0
                ];

                if (DB::init()->connect()->table('section_images')->replace($imageUpload)) {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    /**
     * Загрузка картинок в галерею
     * @param $sectionId
     * @param $images
     * @return bool
     */
    protected function picture($sectionId, $images): bool
    {
        if (!empty($images['gallery'])) {
            if ($order = DB::init()->connect()->table('section_images')->where('sectionId', $sectionId)->max('orderBy')->getValue()) {
                $idx = $order;
            } else {
                $idx = 0;
            }
            foreach ($images['gallery'] as $gallery) {
                $idx++;
                $file = DB::init()->connect()->table('files')->where('fileId', $gallery['fileId'])->get();

                $imageUpload['sectionId'] = $sectionId;
                $imageUpload['fileId']    = $file->fileId;
                $imageUpload['type']      = 'gallery';
                $imageUpload['orderBy']   = $idx;

                DB::init()->connect()->table('section_images')->replace($imageUpload);
            }
            return true;
        }

        return false;
    }

    /**
     * Добавление файлов
     *
     * @param $sectionId
     * @param $images
     * @return bool
     */
    protected function docs($sectionId, $images): bool
    {
        if (!empty($images['docs'])) {
            if ($order = DB::init()->connect()->table('section_images')->where('sectionId', $sectionId)->max('orderBy')->getValue()) {
                $idx = $order;
            } else {
                $idx = 0;
            }
            foreach ($images['docs'] as $gallery) {
                $idx++;
                $file = DB::init()->connect()->table('files')->where('fileId', $gallery['fileId'])->get();

                $imageUpload['sectionId'] = $sectionId;
                $imageUpload['fileId']    = $file->fileId;
                $imageUpload['type']      = 'docs';
                $imageUpload['orderBy']   = $idx;

                DB::init()->connect()->table('section_images')->replace($imageUpload);
            }
            return true;
        }

        return false;
    }

}