<?php

namespace Mnv\Models;

use Mnv\Core\AdminMnv;
use Mnv\Core\Config;
use Mnv\Core\DB;
use Mnv\Core\Files\FileManager;
use PHPMailer\PHPMailer\SMTP;

/**
 * Class Settings
 * @package Mnv\Models
 */
class Settings extends AdminMnv
{

    private static $_table = 'settings';
    private static $_table_stats_visitors = 'stats_visitors';
    private static $table_stats_visits    = 'stats_visits';
    protected $visitsByType = array();
//    protected $settings;
    protected $setting;
    protected $date;
    protected $resultSmtp = array();

    public function clearCache()
    {
        $this->smarty->clearAllCache();
    }

    protected function readListConfig()
    {
       return DB::init()->connect()->table('settings')->select('codename, value')->indexKey('codename')->valueKey('value')->getAllIndexes();
    }


    /**
     * @return bool
     */
    protected function save(): bool
    {
        global $tbl;

        $updateSetting = array();
        $thumbSizeNames = array('small_thumb', 'medium_thumb', 'large_thumb');

        if (!empty($this->setting['old_site_url'])) {
            DB::init()->connect()->query("UPDATE  `$tbl[sections]`  SET  `url` = replace(url, ' " . $this->setting['old_site_url'] . "', '" . $this->setting['site_url'] . "') ")->exec();
            DB::init()->connect()->query("UPDATE  `$tbl[articles]`  SET  `url` = replace(url, '" . $this->setting['old_site_url'] . "', '" . $this->setting['site_url'] . "') ")->exec();
        }

        //old $settings += dbRawQuery("SHOW VARIABLES LIKE 'ft_min_word_len'", 'Variable_name', 'Value');

        foreach ($this->setting as $codename => $value) {
            if (!isset($this->config[$codename]) || $this->config[$codename] != $value) {

                if (in_array($codename, $thumbSizeNames, true)) {
                    $value = (int)$value;
                }

                switch ($codename) {
                    case 'compress_js_css':
//                    $updateHtaccess = true;
                        break;

                    /* control panel language has changed */
                    case 'admin_language':
                        $adminLang = $value;
                        loadLanguage($adminLang);
                        $this->smarty->setCompileId('admin-' . $adminLang);
                        $this->smarty->assign('adminLang', $adminLang);
                        break;
                    case 'website_language':
                        $newWebsiteLang = $value;
                        $oldWebsiteLang = Config::getValue('website_language');
                        $lang_dir = GLOBAL_ROOT.'/includes/languages/';
                        if (is_dir($lang_dir)) {
//                            rename($lang_dir . $oldWebsiteLang . '.json', $lang_dir . $newWebsiteLang . '.json');
                            $src = $lang_dir . $oldWebsiteLang . '.json';
                            $dest = $lang_dir . $newWebsiteLang . '.json';
                            if (file_exists($src) && !file_exists($dest)) {
                                copyFolder($src, $dest);
                            }
                        }
                        break;
                    /* file extension has been changed */
                    case 'file_extension':
//                    $updateHtaccess = true;
                        $oldExtension = $this->config['file_extension'];

                        /* update all article and sections URLs */
                        DB::init()->connect()->query("UPDATE  `$tbl[articles]` SET  `url` = CONCAT(LEFT(`url`, CHAR_LENGTH(url)-CHAR_LENGTH('$oldExtension')), '$settings[file_extension]') WHERE  `url` LIKE '%.$oldExtension'")->exec();
                        DB::init()->connect()->query("UPDATE  `$tbl[sections]` SET  `url` = CONCAT(LEFT(`url`, CHAR_LENGTH(url)-CHAR_LENGTH('$oldExtension')), '$settings[file_extension]') WHERE  `url` LIKE '%.$oldExtension'")->exec();

                        break;

                    case 'bot_id_strings':
                        if ($bots = explode("\r\n", $value)) {
                            $bots = array_map('trim', $bots);
                            $bots = array_preg_quote($bots);
                            $bots = implode('|', $bots);
                        } else {
                            $bots = '';
                        }
                        $updateSetting['codename'] = 'bot_id_regexp';
                        $updateSetting['value'] = $bots;
                        DB::init()->connect()->table(static::$_table)->replace($updateSetting);
                        DB::init()->connect()->query("UPDATE  `$tbl[stats_user_agents]` SET  `isBot` = IF(userAgent RLIKE '" . $bots . "', 1, 0)")->exec();

                    case 'bot_id_regexp':
                    case 'query_fields_strings':
                        if ($queryFields = explode("\r\n", $value)) {
                            $queryFields = array_map('trim', $queryFields);
                            $queryFields = array_preg_quote($queryFields);
                            $queryFields = implode('|', $queryFields);
                        } else {
                            $queryFields = '';
                        }
                        $updateSetting['codename'] = 'query_fields';
                        $updateSetting['value'] = $queryFields;

                        DB::init()->connect()->table(self::$_table)->replace($updateSetting);
                    case 'theme':
                        /* theme has been changed */
                        $this->smarty->clearAllCache();
                        break;
                }

                $updateSetting['codename'] = $codename;
                $updateSetting['value'] = $value;

                DB::init()->connect()->table(self::$_table)->replace($updateSetting);
            }
        }

        return true;
    }


    /**
     * TODO: доработать удаление статистики
     * @param $date
     */
    protected function deleteStatsPriorTo($date): void
    {
        global $tbl;

        $visitors = array();
        $type2table = array(
            2  => 'stats_section_visits',
            3  => 'stats_article_visits',
            4  => 'stats_search_visits',
            5  => 'stats_ad_clicks',
            6  => 'stats_error_visits',
            7  => 'stats_rss_visits'
        );

        $date = date("Y-m-d", strtotime($date));


        do {
            if ($visitorsArr = DB::init()->connect()->table('stats_visitors')->select('visitorId')->where('firstVisitOn', '<', $date)->limit(1000)->getAll()) {
                foreach ($visitorsArr as $visitor) $visitors[$visitor->visitorId] = $visitor;

                do {
                    if ($visitsArr = DB::init()->connect()->table(self::$table_stats_visits)->select('visitId, typeId')->in('visitorId', array_keys($visitors))->limit(1000)->getAll()) {
                    foreach ($visitsArr as $visit) $visits[$visit->visitId] = $visit->typeId;

                        foreach ($visits as $visitId => $typeId) {
                            if (!isset($this->visitsByType[$typeId])) $this->visitsByType[$typeId] = array();
                            $this->visitsByType[$typeId][] = $visitId;
                        }
                        /* deleting each type of visit */
                        foreach($this->visitsByType as $typeId => $typeVisits) {
                            if (!empty($tbl[$type2table[$typeId]])) {
                                DB::init()->connect()->table($type2table[$typeId])->in('visitId', $typeVisits)->delete();
                            }
                        }

                        /* deleting all visits */
                        DB::init()->connect()->table(self::$table_stats_visits)->in('visitId', array_keys($visits))->delete();
                    }
                } while (!empty($visitsArr));

                /* deleting visitors */
                DB::init()->connect()->table(self::$_table_stats_visitors)->in('visitorId', array_keys($visitors))->delete();
            }
        } while (!empty($visitorsArr));
    }


    /**
     * Тестировать подключение SMTP
     */
    protected function testSMTP()
    {

        $this->resultSmtp = [
            'status'  => false,
            'message' => '',
            'trace'   => '',
        ];

        if ((int)$this->setting['smtp_port'] === 465) {
            /** Добавляем протокол, если не указали */
            $this->setting['smtp_server'] = (strpos($this->setting['smtp_server'], "ssl://") === false) ? "ssl://" . $this->setting['smtp_server'] : $this->setting['smtp_server'];
        }

        ob_start();

        $smtp = new SMTP;
        /** Включить вывод отладки на уровне подключения */
        $smtp->do_debug = SMTP::DEBUG_CONNECTION;
        /** Подключение к SMTP-серверу */
        if (!$smtp->connect($this->setting['smtp_server'], $this->setting['smtp_port'])) {
            $this->resultSmtp['message'] = 'Connect failed';
        }
        // Say hello
        if (!$smtp->hello(gethostname())) {
            $this->resultSmtp['message'] = 'EHLO failed: ' . $smtp->getError()['error'];
        }
        /** Получаем список служб ESMTP, предлагаемых сервером */
        $e = $smtp->getServerExtList();
        /** Если сервер может выполнять шифрование TLS, используйте его */
        if (is_array($e) && array_key_exists('STARTTLS', $e)) {
            $tlsOk = $smtp->startTLS();
            if (!$tlsOk) {
                $this->resultSmtp['message'] = 'Failed to start encryption: ' . $smtp->getError()['error'];
            }
            /** Повторите EHLO после STARTTLS */
            if (!$smtp->hello(gethostname())) {
                $this->resultSmtp['message'] = 'EHLO (2) failed: ' . $smtp->getError()['error'];
            }
            /** Получите список новых возможностей, который обычно теперь будет включать авторизацию, если раньше этого не было */
            $e = $smtp->getServerExtList();
        }
        /** Если сервер поддерживает аутентификацию, сделайте это (даже если нет шифрования) */
        if (is_array($e) && array_key_exists('AUTH', $e)) {
            if ($smtp->authenticate($this->setting['smtp_user'], $this->setting['smtp_pass'])) {
                $this->resultSmtp['message'] = 'Connected ok!';
                $this->resultSmtp['status']  = true;
            } else {
                $this->resultSmtp['message'] = 'Authentication failed: ' . $smtp->getError()['error'];
            }
        }

        /** Что бы ни случилось, разрываем связь. */
        $smtp->quit(true);

        $this->resultSmtp['trace'] = nl2br(ob_get_clean());

    }


}