<?php

namespace Mnv\Models\Socials;

use Mnv\Core\AdminMnv;
use Mnv\Core\DB;

class Socials extends AdminMnv
{
    private static $_table = 'socials';

    public $socials;
    public $social;
    public $socialId;

    public $total;

    /**
     * Получение всех социальных сетей
     */
    protected function getAll(): void
    {
        $this->socials = DB::init()->connect()->table(self::$_table)->select('*')->orderBy('orderBy', 'asc')->limit($this->limit)->getAll('array');

        $this->total();
    }

    private function total(): void
    {
        $this->total = DB::init()->connect()->table(static::$_table)->count('*', 'count')->getValue();
    }

    /**
     * Редактирование социальной сети
     */
    protected function edit(): void
    {

        if (!empty($this->socialId)) {
            $this->social = DB::init()->connect()->table(self::$_table)->where('socialId', $this->socialId)->get('array');
        }
    }

    /**
     * Добавление социальной сети
     *
     * @param array|null $social
     * @return bool
     */
    protected function add(?array $social): bool
    {
        if (!empty($social)) {
            $this->socialId = DB::init()->connect()->table(self::$_table)->insert($social);

            $this->edit();

            return true;
        }

        return false;
    }

    /**
     * Обновление социальной сети
     *
     * @param  array|null $social
     * @return bool
     */
    protected function update(?array $social): bool
    {
        if (!empty($this->socialId) && DB::init()->connect()->table(self::$_table)->where('socialId', $this->socialId)->update($social)) {
            $this->edit();

            return true;
        }

        return false;
    }


    /**
     * Удаление
     *
     * @return bool
     */
    protected function remove(): bool
    {
        return !empty($this->socialId) && DB::init()->connect()->table(self::$_table)->where('socialId', $this->socialId)->delete();
    }

    protected function status(): array
    {
        if (!empty($this->socialId)) {
            if ($oldSocialStatus = DB::init()->connect()->table(self::$_table)->select('status')->where('socialId', $this->socialId)->getValue()) {
                $socialUpdate['status'] = ($oldSocialStatus == 'visible') ? 'hidden' : 'visible';
                DB::init()->connect()->table(self::$_table)->where('socialId', $this->socialId)->update($socialUpdate);
                return array('data' => true, 'status' => $socialUpdate['status']);
            }

            return array('data' => false);
        }

        return array('data' => false);
    }
    /**
     * Сортировка
     *
     * @param $socialIds
     */
    protected function reorder($socialIds)
    {
        $i = 0;
        foreach ($socialIds as $socialId) {
            $i++;
            DB::init()->connect()->table(self::$_table)->where('socialId', $socialId)->update(['orderBy' => $i]);
        }
//
//        foreach ($socialIds as $i => $socialId) {
//            DB::init()->connect()->table(self::$_table)->where('socialId', $ids[$i])->update(['orderBy' => $socialId]);
//        }

    }

    /**
     * Проверка на существование во избежание дублирования
     * isFileName
     *
     * @param $fileName
     * @return bool
     */
    protected function isFileName($fileName): bool
    {
        if (!empty($this->socialId)) {
            DB::init()->connect()->where('socialId', '<>', $this->socialId);
        }
        if (!empty($fileName)) $fileName = strtolower($fileName);
        if (DB::init()->connect()->table(self::$_table)->select('socialId')->where('LOWER(fileName)', $fileName)->get()) return false;

        return true;
    }

}