<?php

namespace Mnv\Models\Users;

use Mnv\Core\DB;
use Mnv\Models\Users\Exceptions\NoUserException;
use Mnv\Models\Users\Exceptions\EmptyUserIdException;

class SubscribersUser extends AbstractUser implements UserInterface
{
    private static $_table = 'users';


    /** UsersAdmin constructor */
    public function __construct()
    {
        parent::__construct();

    }

    /**
     * Фильтровать пользователей
     *
     * 1 Для РАЗРАБОТЧИКА получить всех кроме пользователей сайта
     * 2 Для АДМИНИСТРАТОРА  получить всех кроме пользователей сайта и (РАЗРАБОТЧИКА, МЕНЕДЖЕРА,КОНСУЛЬТАНТА, СОТРУДНИКА, ОБСЛУЖИВАНИЕ)
     * 3 Только пользователей сайта
     *
     */
    private function accessLevel(?string $query, ?string $status, $userTypes, $manager = null)
    {
        if (!empty($query)) {
            DB::init()->connect()->grouped(function($q) use ($query) {
                $q->like('email', "%$query%")->orLike('loginName', "%$query%")->orLike('fullName',"%$query%")
                    ->orLike('firstName',"%$query%")->orLike('lastName',"%$query%")->orLike('phone',"%$query%");
            });
        }
        if (!empty($status)) DB::init()->connect()->where('status', $status);

//        if ($userType == 'adminUser') {
//            /** исключить пользователей сайта */
//            DB::init()->connect()->where('userType',  'A');
//        } else {
//            /** только пользователи сайта */
//            DB::init()->connect()->where('userType', 'C');
//        }
    }

    /**
     * Получение всех пользователей
     *
     * @param string|null $query (optional)
     * @param string|null $status (optional)
     * @param null $orderBy (optional)
     * @param null $userTypes
     * @param null $manager (optional)
     */
    public function getAll(?string $query, ?string $status, $orderBy = 'userId DESC', $userTypes, $manager = null) : void
    {
        /** Фильтровать пользователей */
        $this->accessLevel($query, $status, $userTypes, $manager);

        $this->users = DB::init()->connect()->table('subscribe')->select('*')->pagination($this->limit, $this->page)->orderBy($orderBy)->getAll('array');
    }

    /**
     * получение кол-во пользователей
     *
     * @param string|null $query
     * @param string|null $status
     * @param null $manager
     */
    public function total(?string $query, ?string $status, $userTypes, $manager = null) : void
    {
        /** Фильтровать пользователей */
        $this->accessLevel( $query, $status, $userTypes, $manager);
        $this->total = DB::init()->connect()->table('subscribe')->count('*', 'count')->getValue();
    }


    /**
     * Редактирование пользователя
     *
     */
    public function edit(?string $userType) { }

    /**
     * Проверить на существование
     * @param string $field по какому полю проверять (`email` или `phone`)
     * @param string $param приходящий параметр для сравнения
     * @return bool
     */
    public function existSubscribe(string $field, string $param): bool
    {
        if (DB::init()->connect()->table('subscribe')->count('*')->where($field, '=', $param)->getValue()) return true;

        return false;
    }
    /**
     * TODO сделано
     * Сохранение нового пользователя
     *
     * @param $user
     * @param null $manager
     * @return bool
     */
    public function add($user, $manager = null): bool
    {
        if(DB::init()->connect()->table('subscribe')->insert((array)$user)) return true;

        return false;
    }

    /**
     * TODO сделано
     * Обновление информации пользователя
     * @param array $user
     */
    public function update($user, $manager) { }

    /**
     * Удаление пользователя
     *
     * @throws NoUserException
     * @throws EmptyUserIdException
     */
    public function remove(?string $userType)
    {
        if ( $this->userId !== null ) {
            $this->getUser($userType);
            if ($this->user !== null) {
                DB::init()->connect()->table('subscribe')->where('userId', $this->user['userId'])->delete();
            } else {
                throw new NoUserException();
            }
        } else {
            throw new EmptyUserIdException();
        }

    }

    /**
     * Обновление статуса
     */
    public function approve() { }

}