<?php

namespace Mnv\Models;

use Mnv\Core\DB;
use Mnv\Core\Mnv;

/**
 * Class Variants
 * @package Mnv\Models
 */
class Variants extends Mnv
{
    /**
     * OrdersAdmin constructor.
     */
    public function __construct()
    {
        parent::__construct();
    }

    public function convertVariants($variantArrays): array
    {
        $variants = array();
        foreach ($variantArrays as $n => $va) {
            foreach($va as $i => $v) {
                if (empty($variants[$i]))
                    $variants[$i] = new \stdClass;
                $variants[$i]->$n = $v;
            }
        }

        return $variants;
    }

    /**
     * Функция возвращает варианты товара
     * @param $productId
     */
    public function getVariants($productId)
    {
//        print_r($filter);
        if (!empty($productId)) {
            return DB::init()->connect()->table('product_variants')->where('productId', $productId)->orderBy('orderBy')->indexKey('id')->getAllIndexes('array');
        }

        return null;
    }

    public function getVariant($id = null)
    {
        if (!empty($id)) {
            return DB::init()->connect()->table('product_variants')->where('id', intval($id))->get('array');
        }

        return null;
    }

    public function addVariant(array $variant)
    {
        if (empty($variant['id'])) unset($variant['id']);
        if (empty($variant['price'])) $variant['price'] = '0.00';
        if (empty($variant['oldPrice'])) $variant['oldPrice'] = '0.00';
        $variant['orderBy'] = 0;
//        print_r($variant);

        return DB::init()->connect()->table('product_variants')->insert($variant);
//        print_r(DB::init()->connect()->getQuery());
//        return $this->id;
    }

    /**
     * @param int $id
     * @param array $variant
     * @return mixed
     */
    public function updateVariant(int $id, array $variant)
    {
//        print_r($variant);
//        if (empty($variant->sku)) $variant->sku = null;
//        if (empty($variant->price)) $variant->price = '0.00';
//        if (empty($variant->oldPrice)) $variant->oldPrice = '0.00';
        DB::init()->connect()->table('product_variants')->select('*')->where('id', $id)->update((array)$variant);
    }

    public function deleteVariant(int $id)
    {
        DB::init()->connect()->table('product_variants')->where('id', $id)->delete();

    }




}