<?php


namespace Mnv\Modules\Filter;


use Mnv\Core\DB;

class Filter
{

    public function getMarks($carClasses, $section = 3, $noSubsections = false)
    {

        /** add section conditions */
        fetch_articles_addSectionConditions($section, $noSubsections);

        if (!empty($carClasses)) {
            $carClasses = explode("/", $carClasses);
            $sectionIds = DB::init()->connect()->table('sections')->select('sectionId')->in('fileName', (array)$carClasses)->indexKey('sectionId')->valueKey('sectionId')->getAllIndexes();
            DB::init()->connect()->in('sectionId', $sectionIds);
        }

        $marks = DB::init()->connect()->table('articles AS a')->join('brands AS b', 'b.fileName', 'brand')
            ->select('b.brandId, b.name, b.fileName')
            ->where('a.status', 'visible')
            ->orderBy('b.name')->groupBy('b.fileName')
            ->indexKey('fileName')
            ->getAllIndexes();

        if (!empty($marks)) ksort($marks);

        return $marks;
    }

    public function getModels($carClasses, $brand, $section = 3, $noSubsections = false)
    {

        /** add section conditions */
        fetch_articles_addSectionConditions($section, $noSubsections);

        if (!empty($carClasses)) {
            $carClasses = explode("/", $carClasses);
            $sectionIds = DB::init()->connect()->table('sections')->select('sectionId')->in('fileName', (array)$carClasses)->indexKey('sectionId')->valueKey('sectionId')->getAllIndexes();
            DB::init()->connect()->in('sectionId', $sectionIds);
        }
        if (!empty($brand)) {
            $brand = explode("/", $brand);
            DB::init()->connect()->in('brand', (array)$brand);
        }
        $models = DB::init()->connect()->table('articles')
            ->select('title')
            ->where('status', 'visible')
            ->orderBy('orderBy ASC')->groupBy('title')
            ->indexKey('title')
            ->valueKey('title')
            ->getAllIndexes();

        if (!empty($models)) ksort($models);

//        print_r($models);
        return $models;
    }
}