<?php


namespace Mnv\Modules\Payment;

/**
 * Interface PaymentMethodInterface
 * @package Mnv\Api\Payment
 */
interface PaymentMethodInterface
{

    /**
     * Генерация самой формы
     *
     * @param int $orderId
     * @param float $amount
     * @param int|null $userId
     * @param string|null $fullName
     * @param string|null $userPhone
     * @param string|null $userEmail
     * @param string|null $lang
     * @param array|null $note
     * @param bool $auto
     * @return string|null
     */
    public function form(
        int $orderId,
        float $amount,
        int $userId = null,
        string $fullName = null,
        string $userPhone = null,
        string $userEmail = null,
        array $note = null,
        string $lang = null,
        bool $auto = true): ?string;

    /**
     * Генерация инпутов для формы
     *
     * @param int $orderId
     * @param float $amount
     * @param int|null $userId
     * @param string|null $fullName
     * @param string|null $userPhone
     * @param string|null $userEmail
     * @param array|null $note
     * @param string|null $lang
     * @return mixed
     */
    public function fields(int $orderId, float $amount, int $userId = null, string $fullName = null, string $userPhone = null, string $userEmail = null, array $note = null, string $lang = null): ?string;
}