<?php
/******************************************************************************/
//                                                                            //
//                             Smarty plugin                                  //
//                            @package Smarty                                 //
//							 @subpackage plugins                              //
//                        http://life-style.uz/                               //
//                   produced by Life Style, life-style.uz                    //
//                                                                            //
/******************************************************************************/

use Mnv\Core\DB;

function smarty_function_fetch_article($params, &$smarty){
	global $gmNow, $fetchedArticles;

	$assign        = fetch_getParam('assign', $params, 'article');
	$fields        = fetch_getParam('fields', $params, 'sectionId, publishedOn, title, alias, url, summary, isFeatured, counter, addedBy, modifiedBy');
	$status        = fetch_getParam('status', $params, 'visible');
	$isFeatured    = fetch_getParam('isFeatured', $params, NULL);
	$hasImage      = fetch_getParam('hasImage', $params, NULL);
	$query         = fetch_getParam('query', $params, NULL);
	$match         = fetch_getParam('match', $params, 'any');
	$order         = fetch_getParam('order', $params, NULL);
	$orderBy       = fetch_getParam('orderBy', $params, $order);
	$section       = fetch_getParam('section', $params);
	$articleId     = (int) fetch_getParam('articleId', $params);
	$skip          = fetch_getParam('skip', $params, NULL);
	$noSubsections = (boolean) fetch_getParam('noSubsections', $params, false);

	/* conditions */
    DB::init()->connect()->where('publishedOn','<=',$gmNow);
	if(!empty($status)) DB::init()->connect()->where('status',$status);
	if(!is_null($isFeatured)) DB::init()->connect()->where('isFeatured',(boolean) $isFeatured ? 1 : 0);
	if(is_null($orderBy)) DB::init()->connect()->orderBy(is_null($query) ? 'publishedOn DESC' : '');
	if($articleId > 0) DB::init()->connect()->where('articleId',$articleId);
	

	/* query conditions */
	fetch_articles_addQueryConditions($query, $match, $fields, $orderBy);

	/* add section conditions */
	fetch_articles_addSectionConditions($section, $noSubsections);

	/* skipping articles */
	fetch_articles_addSkipConditions($skip);

	/* checking article fields */
	fetch_articles_filterFields($fields);

	/* calculate article popularity article fields */
	fetch_articles_calculatePopularity($orderBy);

	if(!is_null($query) && empty($query)){
		$article = array();
	} else {
        $article =  DB::init()->connect()->table('articles')->select($fields)->get('array');
		$article = prepareArticle($article);
	}
//	print_r($article);
	$smarty->assign($assign, $article);

	/* saving fetched article for SKIP ability */
	if(empty($fetchedArticles[$assign])) {
        $fetchedArticles[$assign] = array();
    }
	if(!empty($article)) {
        $fetchedArticles[$assign][] = $article['articleId'];
    }

	return null;
}
?>