<?php
/******************************************************************************/
//                                                                            //
//                             Smarty plugin                                  //
//                            @package Smarty                                 //
//							 @subpackage plugins                              //
//                        http://life-style.uz/                               //
//                   produced by Life Style, life-style.uz                    //
//                                                                            //
/******************************************************************************/

use Mnv\Core\DB;

function smarty_function_fetch_compares($params, &$smarty){
	
	$assign        = fetch_getParam('assign', $params, 'articles');
    $fields        = fetch_getParam('fields', $params, 'articleId, sectionId, publishedOn, title, alias, url, summary, orderBy, price, oldPrice, typeContent');
	$status        = fetch_getParam('status', $params, 'visible');
	$limit         = (int) fetch_getParam('limit', $params);
	$perPage       = (int) fetch_getParam('perPage', $params, $limit);

	$typeContent  = fetch_getParam('typeContent', $params, 'products');

    $compare       =  fetch_getParam('compare', $params);
	$userId        = (int) fetch_getParam('userId', $params);
	

	$image        = fetch_getParam('image', $params, false);
	$image_type   = fetch_getParam('image_type', $params, 'general');
	
	$sectionInfo  = fetch_getParam('sectionInfo', $params, false);
	$parentsInfo  = fetch_getParam('parentsInfo', $params, false);
	
	
	if (empty($assign)) {
		$smarty->_trigger_fatal_error('fetch_compares: "assign" must not be empty');
		return;
	}
	

	if (!empty($userId)) {
        $compares = DB::init()->connect()->table('shop_compares')->select('articleId')->where('userId', $userId)->getAll('array');
        foreach ($compares as $i => $compare) {
            $compareIndexes[$compare['articleId']] = $i;
        }
    } else {
        $compares = explode(',', $compare);
        foreach ($compares as $i => $compare) {
            $compareIndexes[$compare] = $i;
        }
    }

    if (!empty($compareIndexes)) {
        $articles = DB::init()->connect()->table('articles')->select($fields)->in('articleId', array_keys($compareIndexes))->where('typeContent', $typeContent)->getAll('array');
	    if ($image == true) {
            $articles = prepareArticles($articles, $sectionInfo, $parentsInfo, $image, $image_type);
        }

	    $total =  count($articles);
	    // print_r($articles);
    
        $smarty->assign($assign, $articles);
        $smarty->assign('total', $total);
        		
        return null;
	}


    
}
?>