<?php
/******************************************************************************/
//                                                                            //
//                             Smarty plugin                                  //
//                            @package Smarty                                 //
//							 @subpackage plugins                              //
//                        http://life-style.uz/                               //
//                   produced by Life Style, life-style.uz                    //
//                                                                            //
/******************************************************************************/

use Mnv\Core\DB;

function smarty_function_fetch_favorite($params, &$smarty){
	
	$assign        = fetch_getParam('assign', $params, 'favorites');
    $fields        = fetch_getParam('fields', $params, 'articleId, sectionId, publishedOn, title, alias, url, summary, isFeatured, typeContent, special, brand, counter, id AS variantId, name, sku, price, oldPrice, stock, countryId');

	$limit         = (int) fetch_getParam('limit', $params, 100);
    $favoriteKeys  = fetch_getParam('favorites', $params);
    $userId    = (int) fetch_getParam('userId', $params);
	
	if (empty($assign)) {
		$smarty->_trigger_fatal_error('fetch_favorite_sections: "assign" must not be empty');
		return;
	}

    $features = new \Mnv\Models\Features();

	if (!empty($userId) && $userId > 0) {
        $favoriteKeys = DB::init()->connect()->table('users')->select('favorites')->where('userId', $userId)->getValue();
        $favoriteKeys = explode(',', $favoriteKeys);
	} else {
        $favoriteKeys = explode(',', $favoriteKeys);
	}

	if (!empty($favoriteKeys)) {
        if ($favorites = DB::init()->connect()->table('articles')->join('product_variants', 'productId', 'articleId')->select($fields)->in('articleId', $favoriteKeys)->limit($limit)->getAll('array')) {
            foreach ($favorites as $key => &$favorite) {
                $favorite = prepareArticle($favorite);
                $favorites[$key]['features'] = $features->getProductOptions($favorite['articleId']);
            }

        } else {
            $favorites = null;
        }
        $smarty->assign($assign, $favorites);
        		
        return null;
	}

}
?>