<?php
/******************************************************************************/
//                                                                            //
//                             Smarty plugin                                  //
//                            @package Smarty                                 //
//							 @subpackage plugins                              //
//                        http://life-style.uz/                               //
//                   produced by Life Style, life-style.uz                    //
//                                                                            //
/******************************************************************************/

use Mnv\Core\DB;
use Mnv\Core\Files\Image\ImageSizes;
use Mnv\Models\Variants;

function smarty_function_fetch_products($params, &$smarty){
	global $fetchedArticles;

	$assign        = fetch_getParam('assign', $params, 'products');
	$fields        = fetch_getParam('fields', $params, 'articleId, sectionId, publishedOn, title, alias, url, summary, isFeatured, typeContent, special, brand, counter, rating, votes, countryId, pv.id AS variantId, pv.name, pv.sku, pv.price, pv.oldPrice, pv.stock, po.*');
	$status        = fetch_getParam('status', $params, 'visible');
	$limit         = (int) fetch_getParam('limit', $params, 9);
	$perPage       = (int) fetch_getParam('perPage', $params, $limit);
	$isFeatured    = fetch_getParam('isFeatured', $params, NULL);

	$query         = fetch_getParam('query', $params, NULL);
	$match         = fetch_getParam('match', $params, 'any');
	$order         = fetch_getParam('order', $params, NULL);
	$orderBy       = fetch_getParam('orderBy', $params, $order);
	$groupBy       = fetch_getParam('groupBy', $params, 'pv.productId');
	$grouping      = (boolean) fetch_getParam('grouping', $params, false);
	$section       = fetch_getParam('section', $params);
    $articleId     = fetch_getParam('articleId', $params);
	$page          = (int) fetch_getParam('page', $params);
	$skip          = fetch_getParam('skip', $params, NULL);
	$noSubsections = (boolean) fetch_getParam('noSubsections', $params, false);

    $typeContent    = fetch_getParam('typeContent', $params, 'products');
	$image          = fetch_getParam('image', $params, false);
	$imageType      = fetch_getParam('imageType', $params, 'gallery'); // general, gallery
	
	$sectionInfo    = fetch_getParam('sectionInfo', $params, false);
	$parentsInfo    = fetch_getParam('parentsInfo', $params, false);

    $discount       = (boolean)fetch_getParam('discount', $params, false);
    $stock          = (boolean)fetch_getParam('stock', $params, false);
    $special        = fetch_getParam('special', $params, '');
    if (!empty($special)) {
        $special = explode(",", $special);
        remove_from_array("all", $special, false);
    }

    $brand          = fetch_getParam('brand', $params, '');

	$minPrice 		= (int) fetch_getParam('minPrice', $params, '');
	$maxPrice 		= (int) fetch_getParam('maxPrice', $params, '');

    $carClasses     = fetch_getParam('carClasses', $params, '');
    $model 		    = fetch_getParam('model', $params, '');
//	$alcohol 		= fetch_getParam('alcohol', $params, '');
//    $color 		    = fetch_getParam('color', $params, '');
//    $sugar 		    = fetch_getParam('sugar', $params, '');
//    $year 		    = fetch_getParam('year', $params, '');
//    $mill 		    = fetch_getParam('mill', $params, '');
//    $typeAlc 	    = fetch_getParam('typeAlc', $params, '');

	
	$assignPagination = fetch_getParam('assignPagination', $params);
	$path             = fetch_getParam('path', $params);
	$seFriendly       = (boolean) fetch_getParam('seFriendly', $params);
	$pnFirst          = (int) fetch_getParam('pnFirst', $params, 0);
	$pnBefore         = (int) fetch_getParam('pnBefore', $params, 4);
	$pnAfter          = (int) fetch_getParam('pnAfter', $params, 4);
	$pnLast           = (int) fetch_getParam('pnLast', $params, 0);
	
	if (empty($assign)) {
		$smarty->_trigger_fatal_error('fetch_products: "assign" must not be empty');
		return;
	}
    $features = new \Mnv\Models\Features();

    /** conditions */
	if (empty($path)) $path = array();

    /** calculate article popularity article fields */
    if (!empty($orderBy) && $orderBy == 'popularity') $orderBy = 'popularityLast7days';
    fetch_articles_calculatePopularity($orderBy);

    filterProducts($status, $typeContent, $isFeatured, $articleId, $brand, $orderBy, $query, $discount, $stock, $minPrice, $maxPrice, $carClasses, $model);
    /** conditions */
//    fetch_articles_addFilterConditions($alcohol, $color, $sugar, $year, $mill, $typeAlc);

    /** query conditions */
    if (!is_null($query) && is_array($path)) $path[] = "query=".urlencode($query);
    fetch_articles_addQueryConditions($query, $match, $fields, $orderBy);
    /** add section conditions */
    fetch_articles_addSectionConditions($section, $noSubsections);
    /** skipping articles */
    fetch_articles_addSkipConditions($skip);
    /** checking article fields */
    fetch_articles_filterFields($fields);

	if ($page < 1) $page = 1;

	$products = DB::init()->connect()->table('articles')->select($fields)
        ->join('product_variants AS pv', 'pv.productId', 'articleId')
        ->join('product_options AS po', 'po.productId', 'articleId')
        ->pagination($perPage, $page)
        ->indexkey('articleId')
        ->groupBy($groupBy)
        ->getAll('array');
//	print_r(DB::init()->connect()->getQuery());
//       print_r($products);
    if ($products) {
        $products = prepareArticles($products, $sectionInfo, $parentsInfo, $image, $imageType);
        foreach ($products as $key => $product) {
            if (isset($product['articleId'])) {
                $products[$key]['features'] = $features->getProductOptions($product['articleId']);
            }
        }
    }
    
    


    if ($grouping == true) {
        $products = groupBy($products, 'brand');
    }

    // print_r($products);
    $smarty->assign($assign, $products);

	/** saving fetched articles for SKIP ability */
	if(empty($fetchedArticles[$assign])) {
        $fetchedArticles[$assign] = array();
    }
	if(!empty($products)) {
        foreach ($products as $product) {
            $fetchedArticles[$assign][] = $product['articleId'];
        }
    }

    /** Pagination */
	if (!empty($assignPagination)) {

        /** calculate article popularity article fields */
        fetch_articles_calculatePopularity($orderBy);

        filterProducts($status, $typeContent, $isFeatured, $articleId, $brand, $orderBy, $query, $discount, $stock, $minPrice, $maxPrice, $carClasses, $model);
        /** conditions */
//        fetch_articles_addFilterConditions($alcohol, $color, $sugar, $year, $mill, $typeAlc);

        /** query conditions */
        if (!is_null($query) && is_array($path)) $path[] = "query=".urlencode($query);
        fetch_articles_addQueryConditions($query, $match, $fields, $orderBy);
        /** add section conditions */
        fetch_articles_addSectionConditions($section, $noSubsections);
        /** skipping articles */
        fetch_articles_addSkipConditions($skip);
        /** checking article fields */
        fetch_articles_filterFields($fields);

        $total = DB::init()->connect()->table('articles')->countDistinct('articleId')
            ->join('product_variants AS pv', 'pv.productId', 'articleId')
            ->join('product_options AS po', 'po.productId', 'articleId')
            ->getValue();
//        print_r(DB::init()->connect()->getQuery());
//        print_r($total);
        /** page numbering */
		if (is_array($path)) {
			$path = SITE_URL.'/'.basename($_SERVER['PHP_SELF']).'?'.(!empty($path) ? implode('&', $path).'&' : '');
			$seFriendly = false;
		}
		$pagination = getPageNums($total, $page, $perPage, $pnFirst, $pnBefore, $pnAfter, $pnLast, $path, $seFriendly);
		$smarty->assign($assignPagination, $pagination);
	}
	
	return null;
}

function filterProducts($status, $typeContent, $isFeatured, $articleId, $brand, $orderBy, $query, $discount, $stock, $minPrice, $maxPrice, $carClasses, $model)
{

    if (!empty($carClasses)) {
        $sectionIds = DB::init()->connect()->table('sections')->select('sectionId')->in('fileName', $carClasses)->indexKey('sectionId')->valueKey('sectionId')->getAllIndexes();
        DB::init()->connect()->in('sectionId', $sectionIds);
    }
    if (!empty($model)) DB::init()->connect()->in('title', $model);

    /** conditions */
    DB::init()->connect()->where('publishedOn','<=', gmdate('Y-m-d H:i:s'));
    DB::init()->connect()->where('typeContent', $typeContent);
    if (!empty($status))    DB::init()->connect()->where('status', $status);
    if ($discount)          DB::init()->connect()->where('oldPrice', ">", 0.00);
    if ($stock)             DB::init()->connect()->whereISNullOR('stock', '>',0);
    if (!empty($brand))     DB::init()->connect()->in('brand', $brand);
    if (!empty($special))   DB::init()->connect()->in('special', $special);
    if (!empty($articleId)) DB::init()->connect()->where('articleId', '!=', $articleId);
    if (!empty($minPrice) && !empty($maxPrice)) DB::init()->connect()->between('price', $minPrice, $maxPrice);
    if (!is_null($isFeatured)) DB::init()->connect()->where('isFeatured','=',$isFeatured ? 1 : 0);

    if (empty($orderBy)) {
        DB::init()->connect()->orderBy(is_null($query) ? 'publishedOn DESC' : 'publishedOn DESC');
    } else {
        if ($orderBy == 'popularity') {
            DB::init()->connect()->orderBy('popularityLast7days DESC');
        } else if ($orderBy == 'min') {
            DB::init()->connect()->orderBy('price ASC');
        } else if ($orderBy == 'max') {
            DB::init()->connect()->orderBy('price DESC');
        } else if ($orderBy == 'rating') {
            DB::init()->connect()->orderBy('rating DESC');
        } else {
            DB::init()->connect()->orderBy($orderBy);
        }
    }
}

function groupBy($array, $key): array
{
    $return = array();
    if (!empty($array)) {
        foreach ($array as $val) {
            $return[$val->$key][] = $val;
        }
    }
    return $return;
}

?>