<?php

require_once  '../../includes/visitor.inc.php';


//$this->confirmed = 'confirmed'; //подтвердил
//$this->rejected  = 'rejected';  //отвергнуто
//$this->waiting   = 'waiting';   //ожидание

$arrStatuses = array(
    'waiting'	=> 1,
    'confirmed'	=> 2,
    'rejected'	=> 3,
);


$arrRequest = array();
if(!empty($_POST))
    $arrRequest = $_POST;
else
    $arrRequest = $_GET;

//print_r($arrRequest);


////////////////////////////////////////////////
// Выберем заказ из базы
////////////////////////////////////////////////
/// запрос в базу для получение заказа order_id
$payBox = new PayBoxApi();
$payBox->getOrder(intval($arrRequest['pg_order_id']));
$payBox->getDefaultCurrency();
//print_r($payBox->order);

$thisScriptName = PG_Signature::getOurScriptName();
//print_r($thisScriptName);
//var_dump($thisScriptName);
//if (empty($arrRequest['pg_sig']) || !PG_Signature::check($arrRequest['pg_sig'], $thisScriptName, $arrRequest, PayBoxApi::SECTETKEY))
//    die("Wrong signature");

if (!isset($arrRequest['pg_payment_date'])) {

    $bCheckResult = 0;

    // TODO: разобраться со статусами
    if (empty($payBox->order) || $payBox->order['state'] != $arrStatuses['waiting']) {
//    if (empty($payBox->order)) {
        $error_desc = "Заказ был ранее оплачен. Либо заказа нет, либо его статус " . array_search($payBox->order['state'], $arrStatuses);
    } else if($arrRequest['pg_amount'] != $payBox->convertMoney($payBox->order['finishPrice']) || $arrRequest['pg_amount'] <= 0) {
//    } else if($arrRequest['pg_amount'] != intval($payBox->convertMoney($payBox->order['finishPrice'])) || $arrRequest['pg_amount'] <= 0) {
        $error_desc = "Неверная сумма";
    } else {
        $bCheckResult = 1;
    }

    $arrResponse['pg_salt']              = $arrRequest['pg_salt']; // в ответе необходимо указывать тот же pg_salt, что и в запросе
    $arrResponse['pg_status']            = $bCheckResult ? 'ok' : 'error';
    $arrResponse['pg_error_description'] = $bCheckResult ?  ""  : $error_desc;
    $arrResponse['pg_sig']				 = PG_Signature::make($thisScriptName, $arrResponse, PayBoxApi::SECTETKEY);

    $objResponse = new \SimpleXMLElement('<?xml version="1.0" encoding="utf-8"?><response/>');
    $objResponse->addChild('pg_salt', $arrResponse['pg_salt']);
    $objResponse->addChild('pg_status', $arrResponse['pg_status']);
    $objResponse->addChild('pg_error_description', $arrResponse['pg_error_description']);
    $objResponse->addChild('pg_sig', $arrResponse['pg_sig']);

} else {

    $bResult = 0;

//    print_r($payBox->order['status']);

//    print_r($arrStatuses['rejected']);
//
//    var_dump(in_array($payBox->order['state'], [$arrStatuses['rejected'], $arrStatuses['confirmed']]));
//    var_dump(array_search($payBox->order['status'], [$arrStatuses['rejected'], $arrStatuses['confirmed']]));
//
//    print_r(intval($payBox->convertMoney($payBox->order['finishPrice'])));
    // TODO: разобраться со статусами
    if(empty($payBox->order)
        || ($payBox->order['status'] != "rejected" && $arrRequest['pg_result'] == 0)
        || ($payBox->order['status'] != "confirmed" && $payBox->order['status'] != "waiting" && $arrRequest['pg_result'] == 1)) {
//    if (empty($payBox->order) || array_search($payBox->order['status'], [$arrStatuses['rejected'], $arrStatuses['confirmed']])) {
        $strResponseDescription = "Заказ был ранее оплачен. Либо заказа нет, либо его статус " . array_search($payBox->order['state'], $arrStatuses);
    } else if ($arrRequest['pg_amount'] != $payBox->convertMoney($payBox->order['finishPrice'])  || $arrRequest['pg_amount'] <= 0) { // проверка суммы
//    } else if ($arrRequest['pg_amount'] != intval($payBox->convertMoney($payBox->order['finishPrice']))  || $arrRequest['pg_amount'] <= 0) { // проверка суммы
        $strResponseDescription = "Неверная сумма";
    } else {

        $bResult = 1;

        $strResponseStatus = 'ok';
        $strResponseDescription = "Оплата принята";

        if ($arrRequest['pg_result'] == 1) {
            // Установим статус оплачен
            $payBox->updateOrder(intval($payBox->order['id']), 'confirmed', 2);

            // Спишем товары
            // отправка на email если нужно
        }
        else{
            // Установим отказ
            $payBox->updateOrder(intval($payBox->order['id']), 'rejected', 3);
        }
    }

    if (!$bResult) {
        if ($arrRequest['pg_can_reject'] == 1) {
            $strResponseStatus = 'rejected'; // отклоненный
//            $payBox->updateOrder(intval($payBox->order['id']), 'rejected', 3);
        } else {
            $strResponseStatus = 'error';
        }
    }

    $objResponse = new \SimpleXMLElement('<?xml version="1.0" encoding="utf-8"?><response/>');
    $objResponse->addChild('pg_salt', $arrRequest['pg_salt']); // в ответе необходимо указывать тот же pg_salt, что и в запросе
    $objResponse->addChild('pg_status', $strResponseStatus);
    $objResponse->addChild('pg_description', $strResponseDescription);
    $objResponse->addChild('pg_sig', PG_Signature::makeXML($thisScriptName, $objResponse, PayBoxApi::SECTETKEY));
}

header("Content-type: text/xml");
echo $objResponse->asXML();
die();
