<?php
	include '../includes/overall.inc.php';

use Mnv\Core\Bot\Exceptions\InvalidChatIdException;
use Mnv\Core\Bot\Exceptions\InvalidTokenException;
use Mnv\Core\Bot\Telegram;
use Mnv\Core\Config;
use Mnv\Core\Feedback;
use Mnv\Core\Locale\I18N;
use Mnv\Core\Validations\ValidateEmail;

//global $smarty;
	
	$feedbackClass = new Feedback(Config::getValue('mail_transport'));
    $feedbackClass->getCaptchaEnabled(Config::getValue('feedback_captcha_enabled'));
    $feedbackClass->getAllowCaptcha(Config::getValue('allow_recaptcha'));

    $error    = '';
    $response  = null;
    $captchaGood = false;
    $attachment = null;

    $rewrite   = getRequestVar('rewrite');
    $feedback   = getRequestVar('feedback', '', true);
    $bot        = getRequestVar('bot', '', true);


    if ($rewrite != Config::getValue('rewrite')) {
        header("HTTP/1.0 301 Moved Permanently");
        header("Location: " . SITE_URL);

        exit;
    }


    if (isset($_FILES) && !empty($_FILES['file'])) {
        $attachment = $_FILES['file'];
    }

    if (isset($feedback['email'])) {
        try {
           ValidateEmail::fromString($feedback['email']);
        } catch (\Mnv\Core\Validations\Exceptions\InvalidEmailException | \InvalidArgumentException $e) {
            $feedbackClass->errors = I18N::locale("Укажите корректный e-mail", "To'g'ri elektron pochtani ko'rsating", "Specify the correct email");
        }
    } else {
        $feedback['email'] = null;
    }

    if (empty($feedback['subject'])) {
        $feedback['subject'] = Config::getValue('smtp_subject');
    }
    $feedback['subject'] = preg_replace("/(%0A|%0D|\n|\r)/i", '', trim($feedback['subject']));

    if (!empty($feedback['firstName'])) {
        $feedback['firstName'] = preg_replace("/(%0A|%0D|\n|\r)/i", '', trim($feedback['firstName']));
        $feedbackClass->checkName($feedback['firstName']);
    } else {
        $feedbackClass->errors = I18N::locale("Поле Ф.И.О. не должно быть пустым", "F. I. O. maydoni bo'sh bo'lmasligi kerak", "The full name field should not be empty");
    }

    if (!empty($feedback['lastName'])) {
        $feedback['lastName'] = preg_replace("/(%0A|%0D|\n|\r)/i", '', trim($feedback['lastName']));
        $feedbackClass->checkName($feedback['lastName']);
    } else {
        $feedbackClass->errors = I18N::locale("Поле Ф.И.О. не должно быть пустым", "F. I. O. maydoni bo'sh bo'lmasligi kerak", "The full name field should not be empty");
    }

    if (!empty($feedback['phone'])) {
        $feedback['phone'] = preg_replace("/(%0A|%0D|\n|\r)/i", '', trim($feedback['phone']));
    } else {
        $feedbackClass->errors = I18N::locale("Поле номер телефона не должно быть пустым", "Telefon raqami maydoni bo'sh bo'lmasligi kerak", "The phone number field should not be empty");
    }



    /* checking whether message is empty */
//    if (empty($feedback['message'])) {
//        $feedbackClass->errors = 'message';
//    }


    if (empty($feedbackClass->errors)) {

		$feedback['fullName'] = $feedback['firstName'] . ' ' . $feedback['lastName'];

        $arrayMessage = array_filter([
            'Дата отправки сообщения' => adjustTime(gmdate('d-m-Y H:i'), false, 'd-m-Y H:i'),
            'Ф.И.О.'        => $feedback['fullName'],
            'Телефон'       => $feedback['phone'],
            'Емайл'         => $feedback['email'],
			'Компания'      => $feedback['company'] ?? null,
            'Сообщение'     => $feedback['message'] ?? null
        ]);

        $htmlBody = '';
        foreach($arrayMessage as $key => $value) {
            $htmlBody .= "<b>".$key.":</b> ".$value."<br />";
        }

        /* проверка включена капча */
        if ($feedbackClass->setCaptchaEnabled() == 1) {
            /* вид каптчи */
            if ($feedbackClass->setAllowCaptcha() == 1) {
                if (empty($feedbackClass->errors) && $feedbackClass->captchaToken($_POST['token'])) {
                    $captchaGood = true;
                } else {
                    $response = array('status' => 400, 'message' => $feedbackClass->errors, 'color' => 'red');
                }
            } else {
                if (empty($feedbackClass->errors) && $feedbackClass->antiBot($bot['anti-bot-a'], $bot['anti-bot-q'], $bot['anti-email'])) {
                    $captchaGood = true;
                } else {
                    $response = array('status' => 400, 'message' => $feedbackClass->errors, 'color' => 'red');
                }
            }
        }
        /* если все good то пропускаем на отправку */
        if (empty($feedbackClass->errors) && $captchaGood == true) {
            /* отправка в телеграм */
            try {
                Telegram::send(Config::getValue('telegram_send'), Config::getValue('telegram_token'), Config::getValue('telegram_chat_id'),  br2nl("<b>" . $feedback['subject'] . "</b><br>" .$htmlBody));
            } catch (InvalidChatIdException $e) {
                $feedbackClass->errors =  I18N::locale("Telegram bot setting Empty token", "Telegram bot setting Empty token", "Telegram bot setting Empty token");
            } catch (InvalidTokenException $e) {
                $feedbackClass->errors =  I18N::locale("Telegram bot setting empty chat_id", "Telegram bot setting Empty chat_id", "Telegram bot setting Empty chat_id");
            }
            /* отправка по smtp */
            try {
                if (empty($feedbackClass->errors) && $feedbackClass->send($feedback['email'], $feedback['fullName'], $feedback['subject'], $htmlBody, $attachment)) {
                    $response = array(
                        'status' => 200, 'color' => 'green',
                        'message' => I18N::locale("Ваше сообщение успешно отправлено", "Sizning xabaringiz muvaffaqiyatli yuborildi", "Your message has been sent successfully")
                    );
                    $feedbackClass->insertMail($feedback['email'], $feedback['fullName'], $feedback['phone'], $feedback['subject'], $htmlBody);
                } else {
                    $response = array('status' => 400, 'message' => $feedbackClass->errors, 'color' => 'red');
                }
            } catch (\PHPMailer\PHPMailer\Exception $e) {
                $response = array('status' => 400, 'message' => $e->getMessage(), 'color' => 'red');
            }
        }
    } else {
        $response = array('status' => 400, 'message' => $feedbackClass->errors, 'color' => 'red');
    }


    return response()->json($response, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
  

