<?php

use Mnv\Core\Config;
use Mnv\Core\DB;

require_once('includes/overall.inc.php');
	
	$smarty->setTemplateDir( THEME_ROOT);
	$smarty->setCompileId('main'.Config::getValue('theme'));
	
	$articleId = (int) getRequestVar('articleId');
	$article   = getRequestVar('article', '', $noEscape = true);
	
	if(empty($article)){
		/* preview from articles list */

		if($article = DB::init()->connect()->table('articles')->where('articleId', '=', $articleId)){
			$article = prepareArticle($article);
		} else {
			die('Article not found');
		}
	} else {
		/* preview from "Preview" button */
		$article = prepareArticle($article);
	}
	
	if(!empty($article->sectionId)){
		/* for "you-are-here" navigation */
		$sectionParents = getSectionParents($article->sectionId);
		$smarty->assign('sectionParents', $sectionParents);
		$smarty->assign('activeSection', $article->sectionId);
	}

	$smarty->assign('article', $article);
	$smarty->display('article.tpl');	
	
?>