<?php

require_once "../includes/visitor.inc.php";

use Mnv\Core\Config;
use Mnv\Core\Locale\I18N;
use Mnv\Modules\User\User;
use Mnv\Modules\User\Email;
use Mnv\Modules\User\Login;
use Mnv\Modules\User\Phone;
use Mnv\Modules\User\Individual;


//global $smarty;

    $remember_me = '';
	$response = null;
    $errors = null;

    $action     = getRequestVar('action', '');
	$user       = getRequestVar('user', '', true);
    $id         = (int) getRequestVar('id');
    $selector   = getRequestVar('code');
    $token      = getRequestVar('token');

    switch (Config::getValue('methodAuth')) {
        case 'login':

            $authLogin =  new Login();
            if ($action == 'authLogin') {
                $authLogin->auth($user);
                return response()->json($authLogin->response, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
            } else if ($action == 'registrationLogin') {
                $authLogin->registration($user);
                return response()->json($authLogin->response, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
            }
            break;
        case 'email':

            $authEmail = new Email();

            if ($action == 'authEmail') {
                $authEmail->auth($user);
                return response()->json($authEmail->response, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();

            } else if ($action == 'registrationEmail') {
                $authEmail->registration($user);
                return response()->json($authEmail->response, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();

            } else if ($action == 'confirmEmail') {// подтверждение через email (ссылка)
                $authEmail->confirmEmail($selector, $token);
                $smarty->assign('response', $authEmail->response);
            }  else if ($action == 'recoveryEmail') { // восстановление пароля по email
                $authEmail->recoveryEmail($user);
                return response()->json($authEmail->response, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();

            } else if ($action == 'recoveryConfirmEmail') { // восстановление пароля по email
                $authEmail->recoveryConfirmEmail($user);
                return response()->json($authEmail->response, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
            }
            break;
        case 'phone':

            $authPhone = new Phone();

            if ($action == 'authPhone') {
                $authPhone->auth($user);
                return response()->json($authPhone->response, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();

            } else if ($action == 'registrationPhone') {
                $authPhone->registration($user);
                return response()->json($authPhone->response, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();

            } else if ($action == 'confirmSms') {
                $authPhone->confirmSms($user);
                return response()->json($authPhone->response, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
            } else if ($action == 'recoveryPhone') {

                $authPhone->recoveryPhone($user);
                return response()->json($authPhone->response, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
             } else if ($action == 'recoveryConfirm') {

                $authPhone->recoveryConfirmPhone($user);
                return response()->json($authPhone->response, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
            }
            else if  ($action == 'changeContact') {
//                print_r('change_contact');
                $authPhone->changePhone($user);
                return response()->json($authPhone->response, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();

            }
//            else if  ($action == 'changePassport') {
//                if (!empty($user['pSeries']) && !empty($user['pNumber'])) {
//                    $user['pSeries'] = mb_strtoupper($user['pSeries']);
//                    if (strlen($user['pSeries']) == 2 && preg_match('/^[A-Z]+$/iu', $user['pSeries'])) {
//                        if (is_numeric($user['pNumber']) && strlen($user['pNumber']) == 7) {
//                            if (!empty($user['pinfl']) && strlen($user['pinfl']) == 14) {
//                                $authPhone->changePassport($user);
//                            } else {
//                                $authPhone->response = ['status' => 403, 'color' => 'red',
//                                    'message' => I18N::locale("ПИНФЛ не должны быть пустым, и состоит из 14-значного номера", "Too many requests!", "Too many requests!")
//                                ];
//                            }
//                        } else {
//                            $authPhone->response = ['status' => 403, 'color' => 'red',
//                                'message' => I18N::locale("Номер паспорта состоит из 7 цифр", "Too many requests!", "Too many requests!")
//                            ];
//                        }
//                    } else {
//                        $authPhone->response = ['status' => 403, 'color' => 'red',
//                            'message' => I18N::locale("Серия паспорта должна содержать 2 символа", "Too many requests!", "Too many requests!")
//                        ];
//                    }
//
//
//                } else {
//                    $authPhone->response = ['status' => 403, 'color' => 'red',
//                        'message' => I18N::locale("Серия и номер паспорта не должны быть пустыми", "Too many requests!", "Too many requests!")
//                    ];
//                }
//                response()->json($authPhone->response, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
//
//            }
            break;

        case 'individual':

            /** Индивидуальная регистрация/авторизация пользователей */
            $authIndividual = new Individual();

            // TODO: сделано
            // 1 проверить существование номера телефона
            // 2 если пользователь существует подгружаем поля для пароля
            // 3 если пользователя не существует то подгружаем поля для пароля и повторить пароль
            // 4 для нового пользователя регистрируем и выводим подтверждение смс
            // 5 для уже зарегистрированного авторизуем

            /** Проверка на существование номера телефона */
            if ($action == 'authCheck') {

                $authIndividual->check($user);
                return response()->json($authIndividual->response, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();

            /** Авторизация */
            } else if ($action == 'authPhone') {

                $authIndividual->auth($user);
                return response()->json($authIndividual->response, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();

            /** Регистрация по номеру телефона */
            } else if ($action == 'registrationPhone') {

                if (!empty($user['password']) && !empty($user['confirmPassword'])) {
                    $user['password'] = \trim($user['password']);
                    $user['confirmPassword'] = \trim($user['confirmPassword']);

                    if ($user['password'] === $user['confirmPassword']) {
                        $authIndividual->registration($user);
                    } else {
                        $authIndividual->response = array('status' => 403, 'color'=> 'red',
                            'message' => I18N::locale("Поля пароль и подтвердить пароль не совпадают", "Nastroyte to'g'ri sms shlyuz!", "Set up the right sms gateway!")
                        );
                    }
                } else {
                    $authIndividual->response = array('status' => 403, 'color'=> 'red',
                        'message' => I18N::locale("Поля пароль и подтвердить пароль не должны быть пустыми", "Nastroyte to'g'ri sms shlyuz!", "Set up the right sms gateway!")
                    );
                }

                return response()->json($authIndividual->response, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();


            /** Подтверждение регистрации и авторизации через смс */
            } else if ($action == 'confirmPhone' || $action == 'confirmSms') {

                $authIndividual->confirmSms($user);
                return response()->json($authIndividual->response, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();

            /** Восстановление пароля */
            } else if ($action == 'recoveryPhone') {

                $authIndividual->recoveryPhone($user);
                return response()->json($authIndividual->response, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();

            /** Подтверждение восстановление пароля */
            } else if ($action == 'recoveryConfirm') {

                $authIndividual->recoveryConfirmPhone($user);
                return response()->json($authIndividual->response, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();

            /** Изменение номера телефона */
            } else if  ($action == 'changeContact') {

                $authIndividual->changePhone($user);
                return response()->json($authIndividual->response, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();

            /** Подтверждение на изменение номера телефона */
            } else if ($action == 'changeConfirmContact') {

                $authIndividual->changeConfirmContact($user);
                return response()->json($authIndividual->response, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();

            /** Добавление/Изменение паспортных данных */
            } else if ($action == 'changePassport') {

                if (!empty($user['pSeries']) && !empty($user['pNumber'])) {
                    $user['pSeries'] = mb_strtoupper($user['pSeries']);
                    if (strlen($user['pSeries']) == 2 && preg_match('/^[A-Z]+$/iu', $user['pSeries'])) {
                        if (is_numeric($user['pNumber']) && strlen($user['pNumber']) == 7) {
                            if (!empty($user['pinfl']) && strlen($user['pinfl']) == 14) {
                                $authIndividual->changePassport($user);
                            } else {
                                $authIndividual->response = ['status' => 403, 'color' => 'red',
                                    'message' => I18N::locale("ПИНФЛ не должны быть пустым, и состоит из 14-значного номера", "Too many requests!", "Too many requests!")
                                ];
                            }
                        } else {
                            $authIndividual->response = ['status' => 403, 'color' => 'red',
                                'message' => I18N::locale("Номер паспорта состоит из 7 цифр", "Too many requests!", "Too many requests!")
                            ];
                        }
                    } else {
                        $authIndividual->response = ['status' => 403, 'color' => 'red',
                            'message' => I18N::locale("Серия паспорта должна содержать 2 символа", "Too many requests!", "Too many requests!")
                        ];
                    }
                } else {
                    $authIndividual->response = ['status' => 403, 'color' => 'red',
                        'message' => I18N::locale("Серия и номер паспорта не должны быть пустыми", "Too many requests!", "Too many requests!")
                    ];
                }
                return response()->json($authIndividual->response, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
            }

            break;
    }

    if ($action == 'changeUser') {
        $authUser =  new User();
        $authUser->changeUser($user);
        return response()->json($authUser->response, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();

    } else if ($action == 'changePhoto') {
        $authUser =  new User();
        $authUser->changePhoto($_FILES);
        return response()->json($authUser->response, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();


    } else if ($action == 'changePwd') {
        $authUser = new User();
        if ($user['newPassword'] == $user['confirmPassword']) {
            $authUser->changePassword($user);
        } else {
            $authUser->response = array('status' => 403, 'color'=> 'red',
                'message' => I18N::locale("Новый пароль и подтвердить пароль не совпадают", "Yangi parol va parolni tasdiqlash bir xil emas", "New password and confirm password do not match")
            );
        }
        return response()->json($authUser->response, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();

    } else if  ($action == 'removePhoto') {
        print_r('remove_file');

    } else if ($action == 'logout') {
        $authUser =  new User();
        $authUser->logout();
        return response()->json($authUser->response, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
    }




	
	