{include file="header.tpl" title=$section.meta_title keywords=$section.keywords description=$section.description}

<main class="main">

    {* слайдер *}
    {include file="modules/slider.tpl"}
    {* слайдер *}

    <!-- about -->
    {fetch_section assign=aboutSection section=2}{if $aboutSection.status eq 'visible'}
    <section class="flex:col pad-t-100 pad-b-50">
        <div class="flex:col-max">

            <div class="both max">

                <div class="both__item">

                    <div class="text-tmp title-44 title-line">
                        <h2>{$aboutSection.name}</h2>

                        {$aboutSection.content nofilter}
                    </div>

                    <a class="btn black transparent large" href="{$aboutSection.url}">Подробнее</a>

                </div>

                <div class="both__item">
                    <div class="text-tmp">
                        <img src="{$aboutSection.image->original}" alt="{$aboutSection.title nofilter}">
                    </div>
                </div>

            </div>

        </div>
    </section>
    {/if}
    {fetch_section assign=abouttwoSection section=23}{if $abouttwoSection.status eq 'visible'}
    <section class="flex:col pad-t-50 pad-b-100">
        <div class="flex:col-max">

            <div class="both reverse max">

                <div class="both__item">

                    <div class="text-tmp title-44 title-line">
                        <h2>{$abouttwoSection.name}</h2>

                        {$abouttwoSection.content nofilter}
                    </div>

                    <a class="btn black transparent large" href="{$abouttwoSection.url}">Подробнее</a>

                </div>

                <div class="both__item">
                    <div class="text-tmp">
                        <img src="{$abouttwoSection.image->original}" alt="{$abouttwoSection.title nofilter}">
                    </div>
                </div>

            </div>

        </div>
    </section>
    {/if}
    <!-- projects -->
    {fetch_section assign=projectSection section=15}{if $projectSection.status eq 'visible'}
    <section class="flex:col pad-tb-100 bg-white">
        <div class="flex:col-max">

            <div class="grid:fr-1 g-gap-50">

                <div class="head">

                    <div class="head__info">
                        <div class="text-tmp title-44 title-line">
                            <h2>{$projectSection.name}</h2>
                        </div>
                    </div>

                </div>

                <div class="prj-slider">

                    <div class="swiper prj-slider_js">
                        <div class="swiper-wrapper">
                            {fetch_articles limit=7 assign=project image=true section=$projectSection.sectionId}
                            {if !empty($project)}
                            {foreach from=$project item=projectContent}
                            <div class="swiper-slide">

                                <a class="prj-card" href="{$projectContent.url}">

                                    <div class="prj-card__img">
                                        <img src="{$projectContent.image->original}" alt="{$projectContent.title}">
                                    </div>

                                    <div class="prj-card__info">
                                        <div class="text-tmp title-24 color-white">
                                            <h3>{$projectContent.title}</h3>
                                        </div>

                                        <div class="btn-more">
                                            Подробнее

                                            <svg fill="none" xmlns="http://www.w3.org/2000/svg">
                                                <use
                                                    xlink:href="{$ASSETS_URL}/images/sprites/sprite.svg#arrow-right-long">
                                                </use>
                                            </svg>
                                        </div>
                                    </div>

                                </a>

                            </div>
                            {/foreach}
                            {/if}
                        </div>
                    </div>

                </div>

                <div class="block-footer">

                    <a class="btn black transparent large" href="{$projectSection.url}">Все проекты</a>

                    <div class="arrow-slider-container">

                        <button class="arrow-slider prj-prev_js">
                            <svg fill="none" xmlns="http://www.w3.org/2000/svg">
                                <use xlink:href="{$ASSETS_URL}/images/sprites/sprite.svg#arrow-left"></use>
                            </svg>
                        </button>

                        <button class="arrow-slider prj-next_js">
                            <svg fill="none" xmlns="http://www.w3.org/2000/svg">
                                <use xlink:href="{$ASSETS_URL}/images/sprites/sprite.svg#arrow-right"></use>
                            </svg>
                        </button>

                    </div>

                </div>

            </div>

        </div>
    </section>
    {/if}
    <!-- service -->
    {fetch_section assign=servSection section=19}{if $servSection.status eq 'visible'}
    <section class="flex:col pad-tb-100">
        <div class="flex:col-max">

            <div class="grid:fr-1 g-gap-50">

                <div class="head">

                    <div class="head__info">
                        <div class="text-tmp title-44 title-line">
                            <h2>{$servSection.name}</h2>
                        </div>
                    </div>

                </div>

                <div class="grid:fr-3 g-gap-20 full">
                    {fetch_articles limit=7 assign=serv image=true section=$servSection.sectionId}
                    {if !empty($serv)}
                    {foreach from=$serv item=servContent}
                    <div class="service-card" data-id="service">

                        <div class="service-card__img">
                            <img src="{$servContent.image->original}" alt="{$servContent.title}">
                        </div>

                        <div class="service-card__info">

                            <div class="text-tmp title-24">
                                <h3>{$servContent.title}</h3>

                                {$servContent.summary nofilter}
                            </div>

                            <div class="btn-more accent1-theme">
                                Подробнее

                                <svg fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <use xlink:href="{$ASSETS_URL}/images/sprites/sprite.svg#arrow-right-long"></use>
                                </svg>
                            </div>
                           {include file="modules/head-info.tpl"}
                        </div>

                    </div>
                    {/foreach}
                    {/if}

                </div>

                <div class="btns-wrap center">
                    <a class="btn black transparent large" href="{$servSection.url}">Все услуги</a>
                </div>

            </div>

        </div>
    </section>
    {/if}
    <!-- news -->
    {fetch_section assign=newsSection section=13}{if $newsSection.status eq 'visible'}
    <section class="flex:col pad-t-100 pad-b-50 bg-white">
        <div class="flex:col-max">

            <div class="grid:fr-1 g-gap-50">

                <div class="head">

                    <div class="head__info">
                        <div class="text-tmp title-44 title-line">
                            <h2>{$newsSection.name}</h2>
                        </div>
                    </div>

                </div>

                <div class="news-slider">

                    <div class="swiper news-slider_js">
                        <div class="swiper-wrapper">

                            {fetch_articles limit=7 assign=news image=true section=$newsSection.sectionId
                            typeContent="news"}
                            {if !empty($news)}
                            {foreach from=$news item=newsContent}
                            <div class="swiper-slide">
                                <a class="news-card" href="{$newsContent.url}">

                                    <div class="news-card__img">
                                        <img src="{$newsContent.image->original}" alt="">
                                    </div>

                                    <div class="news-card__info">

                                        <time>{$newsContent.publishedOn|date_format:$config.date_format_custom}</time>

                                        <div class="text-tmp title-16">
                                            <h3>{$newsContent.title}</h3>
                                        </div>

                                        <div class="btn-more accent-theme">
                                            Подробнее

                                            <svg fill="none" xmlns="http://www.w3.org/2000/svg">
                                                <use
                                                    xlink:href="{$ASSETS_URL}/images/sprites/sprite.svg#arrow-right-long">
                                                </use>
                                            </svg>
                                        </div>

                                    </div>

                                </a>
                            </div>
                            {/foreach}
                            {/if}
                        </div>
                    </div>

                </div>

                <div class="block-footer">

                    <a class="btn black transparent large" href="{$newsSection.url}">Все новости</a>

                    <div class="arrow-slider-container">

                        <button class="arrow-slider news-prev_js">
                            <svg fill="none" xmlns="http://www.w3.org/2000/svg">
                                <use xlink:href="{$ASSETS_URL}/images/sprites/sprite.svg#arrow-left"></use>
                            </svg>
                        </button>

                        <button class="arrow-slider news-next_js">
                            <svg fill="none" xmlns="http://www.w3.org/2000/svg">
                                <use xlink:href="{$ASSETS_URL}/images/sprites/sprite.svg#arrow-right"></use>
                            </svg>
                        </button>

                    </div>

                </div>

            </div>

        </div>
    </section>
    {/if}
    <!-- contacts -->
    <section class="flex:col pad-t-50 pad-b-100 bg-white">
        <div class="flex:col-max">

            <div class="grid:fr-1 g-gap-50">

                <div class="head">

                    <div class="head__info">
                        <div class="text-tmp title-44 txt-24 title-line txt-tt-up txt-fw-700 ff-f">
                            <h2>{$newsSection.name}</h2>
                        </div>
                    </div>

                </div>

                <div class="both max">

                    <div class="both__item">

                        <div class="contacts">
                            {include file="modules/form.tpl"}


                            <div class="contacts__list-wrap">
                                <ul>
                                    <li>Мы находимся</li>
                                    <li>{$config.address nofilter}</li>
                                </ul>

                                <ul>
                                    <li>Телефон</li>
                                    {assign var=phones value=", "|explode:$config.phone}
                                    {foreach from=$phones item=phone}
                                    <li><a href="tel:{$phone|strip_phone}">{$phone|format_phone} </a></li>
                                    {/foreach}
                                </ul>

                                <ul>
                                    <li>Напишите нам</li>
                                    <li><a href="mailto:{$config.email}">{$config.email}</a></li>
                                </ul>

                                <div class="social">
                                    <ul>
                                        <li>
                                            {include file="modules/block-socials.tpl" class="social"}
                                        </li>
                                    </ul>
                                </div>
                            </div>
                        </div>

                    </div>

                    <div class="both__item">
                        <div class="map" id="map">

                        </div>
                    </div>

                </div>

            </div>

        </div>
    </section>

    {include file="modules/head-info.tpl"}


</main>

{include file="footer.tpl"}